/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import java.net.InetAddress;
import java.util.Objects;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.wsman.WSManEndpoint;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.netmgt.config.wsman.credentials.Definition;
import org.opennms.netmgt.config.wsman.credentials.Range;
import org.opennms.netmgt.config.wsman.credentials.WsmanConfig;
import org.opennms.netmgt.dao.WSManConfigDao;

public class WSManConfigDaoJaxb
extends AbstractJaxbConfigDao<WsmanConfig, WsmanConfig>
implements WSManConfigDao {
    public WSManConfigDaoJaxb() {
        super(WsmanConfig.class, "WS-Man Configuration");
    }

    @Override
    public WsmanConfig getConfig() {
        return (WsmanConfig)this.getContainer().getObject();
    }

    @Override
    public Definition getAgentConfig(InetAddress agentInetAddress) {
        Objects.requireNonNull(agentInetAddress);
        for (Definition def : this.getConfig().getDefinition()) {
            for (String saddr : def.getSpecific()) {
                InetAddress addr = InetAddressUtils.addr((String)saddr);
                if (!addr.equals(agentInetAddress)) continue;
                return def;
            }
            for (Range rng : def.getRange()) {
                if (!InetAddressUtils.isInetAddressInRange((String)InetAddressUtils.str((InetAddress)agentInetAddress), (String)rng.getBegin(), (String)rng.getEnd())) continue;
                return def;
            }
            for (String ipMatch : def.getIpMatch()) {
                if (!IPLike.matches((String)InetAddressUtils.str((InetAddress)agentInetAddress), (String)ipMatch)) continue;
                return def;
            }
        }
        return new Definition(this.getConfig());
    }

    @Override
    public WSManEndpoint getEndpoint(InetAddress agentInetAddress) {
        return WSManConfigDao.getEndpoint(this.getAgentConfig(agentInetAddress), agentInetAddress);
    }

    protected WsmanConfig translateConfig(WsmanConfig config) {
        return config;
    }
}

