/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.osgi;

import com.vaadin.ui.UI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.opennms.vaadin.extender.ApplicationFactory;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;

public class OnmsVaadinUIFactory
implements ApplicationFactory {
    private final BlueprintContainer m_blueprintContainer;
    private final String m_uiBeanId;
    private final Class<? extends UI> m_uiClass;

    public OnmsVaadinUIFactory(Class<? extends UI> uiClass, BlueprintContainer blueprintContainer, String uiBeanId) {
        this.m_blueprintContainer = Objects.requireNonNull(blueprintContainer);
        this.m_uiClass = Objects.requireNonNull(uiClass);
        this.m_uiBeanId = Objects.requireNonNull(uiBeanId);
        this.validate();
    }

    public Map<String, String> getAdditionalHeaders() {
        return Collections.emptyMap();
    }

    public UI createUI() {
        UI ui = (UI)this.m_blueprintContainer.getComponentInstance(this.m_uiBeanId);
        return ui;
    }

    public Class<? extends UI> getUIClass() {
        return this.m_uiClass;
    }

    private void validate() {
        Object instance = this.m_blueprintContainer.getComponentInstance(this.m_uiBeanId);
        if (!(instance instanceof UI)) {
            throw new IllegalStateException("The bean with id " + this.m_uiBeanId + " must be of type " + UI.class);
        }
        ComponentMetadata componentMetadata = Objects.requireNonNull(this.m_blueprintContainer.getComponentMetadata(this.m_uiBeanId));
        if (!(componentMetadata instanceof BeanMetadata)) {
            throw new IllegalStateException("The referenced id is not a bean");
        }
        if (!"prototype".equals(((BeanMetadata)componentMetadata).getScope())) {
            throw new IllegalStateException("The scope of the defined bean with id " + this.m_uiBeanId + " must be " + "prototype" + " but is " + "singleton");
        }
    }
}

