/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext2.cm.change;

import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext2.cm.change.AbstractCmChange;
import liquibase.ext2.cm.database.CmDatabase;
import liquibase.ext2.cm.statement.GenericCmStatement;
import liquibase.statement.SqlStatement;
import org.apache.commons.lang3.ObjectUtils;
import org.opennms.features.config.dao.api.ConfigDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DatabaseChange(name="registerSchema", description="Registers a new schema", priority=5)
public class RegisterSchema
extends AbstractCmChange {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterSchema.class);
    private String id;
    private Boolean allowMultiple = false;

    @Override
    public ValidationErrors validate(CmDatabase database, ValidationErrors validationErrors) {
        this.checkRequiredField(validationErrors, "id", this.id);
        return validationErrors;
    }

    public String getConfirmationMessage() {
        return String.format("Registered new schema with schemaName=%s", this.id);
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new GenericCmStatement(m -> {
            LOG.info("Registering new schema with schemaName={}", (Object)this.id);
            try {
                ConfigDefinition definition = new ConfigDefinition(this.id, this.allowMultiple);
                m.registerConfigDefinition(this.id, definition);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        })};
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getAllowMultiple() {
        return (Boolean)ObjectUtils.defaultIfNull((Object)this.allowMultiple, (Object)false);
    }

    public void setAllowMultiple(Boolean allowMultiple) {
        this.allowMultiple = (Boolean)ObjectUtils.defaultIfNull((Object)allowMultiple, (Object)false);
    }
}

