/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.GroupFactory;
import org.opennms.netmgt.config.UserManager;

public class UserFactory
extends UserManager {
    private static final long RELOAD_CHECK_INTERVAL_MS = TimeUnit.SECONDS.toMillis(1L);
    private static UserManager instance;
    private static boolean initialized;
    private File m_usersConfFile;
    private long m_lastModified;
    private long m_fileSize;
    private AtomicLong m_lastReloadCheck = new AtomicLong(0L);

    public UserFactory() throws FileNotFoundException, IOException {
        super(GroupFactory.getInstance());
        this.reload();
    }

    public static synchronized void init() throws IOException, FileNotFoundException {
        if (instance == null || !initialized) {
            GroupFactory.init();
            instance = new UserFactory();
            initialized = true;
        }
    }

    public static synchronized UserManager getInstance() {
        return instance;
    }

    public static synchronized void setInstance(UserManager mgr) {
        initialized = true;
        instance = mgr;
    }

    @Override
    public synchronized void reload() throws IOException, FileNotFoundException {
        this.m_usersConfFile = ConfigFileConstants.getFile((int)ConfigFileConstants.USERS_CONF_FILE_NAME);
        FileInputStream configIn = new FileInputStream(this.m_usersConfFile);
        this.m_lastModified = this.m_usersConfFile.lastModified();
        this.m_fileSize = this.m_usersConfFile.length();
        this.parseXML(configIn);
        initialized = true;
    }

    @Override
    protected void saveXML(String writerString) throws IOException {
        if (writerString != null) {
            OutputStreamWriter fileWriter = null;
            try {
                fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_usersConfFile), StandardCharsets.UTF_8);
                fileWriter.write(writerString);
                ((Writer)fileWriter).flush();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)fileWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUpdateNeeded() {
        if (this.m_usersConfFile == null) {
            return true;
        }
        long now = System.currentTimeMillis();
        if (now < this.m_lastReloadCheck.get() + RELOAD_CHECK_INTERVAL_MS) {
            return false;
        }
        this.m_lastReloadCheck.set(now);
        UserFactory userFactory = this;
        synchronized (userFactory) {
            long fileLastModified = this.m_usersConfFile.lastModified();
            if (this.m_fileSize != this.m_usersConfFile.length()) {
                return true;
            }
            return this.m_lastModified != fileLastModified;
            {
            }
        }
    }

    @Override
    public void doUpdate() throws IOException, FileNotFoundException {
        if (this.isUpdateNeeded()) {
            this.reload();
        }
    }

    @Override
    public long getLastModified() {
        return this.m_lastModified;
    }

    @Override
    public long getFileSize() {
        return this.m_fileSize;
    }

    static {
        initialized = false;
    }
}

