/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.rtc.RTCConfiguration;
import org.springframework.beans.factory.InitializingBean;

public final class RTCConfigFactory
implements InitializingBean {
    private RTCConfiguration m_config;

    private static long parseRollingWindow(String rolling) throws IllegalArgumentException {
        String hrStr = null;
        String minStr = null;
        String secStr = null;
        rolling = rolling.toLowerCase();
        int hIndex = rolling.indexOf(104);
        int mIndex = rolling.indexOf(109);
        int sIndex = rolling.indexOf(115);
        if (hIndex != -1) {
            hrStr = rolling.substring(0, hIndex);
        }
        if (mIndex != -1) {
            if (hIndex != -1) {
                if (hIndex >= mIndex) {
                    throw new IllegalArgumentException("RTC: Value " + rolling + " - format incorrect");
                }
                minStr = rolling.substring(hIndex + 1, mIndex);
            } else {
                minStr = rolling.substring(0, mIndex);
            }
        }
        if (sIndex != -1) {
            if (mIndex != -1) {
                if (mIndex >= sIndex) {
                    throw new IllegalArgumentException("RTC: Value " + rolling + " - format incorrect");
                }
                secStr = rolling.substring(mIndex + 1, sIndex);
            } else if (hIndex != -1) {
                if (hIndex >= sIndex) {
                    throw new IllegalArgumentException("RTC: Value " + rolling + " - format incorrect");
                }
                secStr = rolling.substring(hIndex + 1, sIndex);
            } else {
                secStr = rolling.substring(0, sIndex);
            }
        }
        int hours = 0;
        int min = 0;
        int sec = 0;
        try {
            if (hrStr != null) {
                hours = Integer.parseInt(hrStr);
            }
            if (minStr != null) {
                min = Integer.parseInt(minStr);
            }
            if (secStr != null) {
                sec = Integer.parseInt(secStr);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("RTC: Value " + rolling + " - format incorrect");
        }
        return (long)(hours * 3600 + min * 60 + sec) * 1000L;
    }

    public RTCConfigFactory() {
    }

    public RTCConfigFactory(InputStream stream) throws IOException {
        this.m_config = RTCConfigFactory.unmarshal(stream);
    }

    private static RTCConfiguration unmarshal(InputStream stream) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(stream);){
            RTCConfiguration rTCConfiguration = (RTCConfiguration)JaxbUtils.unmarshal(RTCConfiguration.class, (Reader)isr);
            return rTCConfiguration;
        }
    }

    public void afterPropertiesSet() throws IOException {
        File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.RTC_CONFIG_FILE_NAME);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(configFile);
            this.m_config = RTCConfigFactory.unmarshal(stream);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    public int getUpdaters() {
        return this.m_config.getUpdaters();
    }

    public int getSenders() {
        return this.m_config.getSenders();
    }

    public String getRollingWindowStr() {
        return this.m_config.getRollingWindow();
    }

    public long getRollingWindow() {
        return RTCConfigFactory.parseRollingWindow(this.m_config.getRollingWindow());
    }

    public int getMaxEventsBeforeResend() {
        return this.m_config.getMaxEventsBeforeResend();
    }

    public String getLowThresholdIntervalStr() {
        return this.m_config.getLowThresholdInterval();
    }

    public long getLowThresholdInterval() {
        return RTCConfigFactory.parseRollingWindow(this.m_config.getLowThresholdInterval());
    }

    public String getHighThresholdIntervalStr() {
        return this.m_config.getHighThresholdInterval();
    }

    public long getHighThresholdInterval() {
        return RTCConfigFactory.parseRollingWindow(this.m_config.getHighThresholdInterval());
    }

    public String getUserRefreshIntervalStr() {
        return this.m_config.getUserRefreshInterval();
    }

    public long getUserRefreshInterval() {
        return RTCConfigFactory.parseRollingWindow(this.m_config.getUserRefreshInterval());
    }

    public int getErrorsBeforeUrlUnsubscribe() {
        return this.m_config.getErrorsBeforeUrlUnsubscribe();
    }
}

