/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.twin.jms.publisher;

import org.opennms.core.ipc.twin.api.TwinStrategy;
import org.opennms.core.logging.Logging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@Conditional(value={Condition.class})
@ImportResource(value={"/META-INF/opennms/applicationContext-twin-jms-publisher.xml"})
public class ConditionalJmsTwinContext {
    private static final Logger LOG = LoggerFactory.getLogger(ConditionalJmsTwinContext.class);

    static class Condition
    implements ConfigurationCondition {
        Condition() {
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION;
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            boolean enabled = TwinStrategy.Strategy.JMS.equals((Object)TwinStrategy.getTwinStrategy());
            try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"ipc");){
                LOG.debug("Enable Jms Twin : {}", (Object)enabled);
            }
            return enabled;
        }
    }
}

