/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.api;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class Host {
    private final String ip;
    private final String hostname;

    public Host(String ip) {
        this.ip = Objects.requireNonNull(ip);
        this.hostname = null;
    }

    public Host(String ip, String hostname) {
        this.ip = Objects.requireNonNull(ip);
        this.hostname = hostname;
    }

    public Host(Builder builder) {
        this.ip = Objects.requireNonNull(builder.ip);
        this.hostname = builder.hostname;
    }

    public String getIp() {
        return this.ip;
    }

    public Optional<String> getHostname() {
        return Optional.ofNullable(this.hostname);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(String ip) {
        return new Builder().withIp(ip);
    }

    public static Builder from(Host host) {
        return new Builder().withIp(host.ip).withHostname(host.hostname);
    }

    public static Builder forOther() {
        return Host.builder().withIp("Other");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Host)) {
            return false;
        }
        Host host = (Host)o;
        return Objects.equals(this.ip, host.ip) && Objects.equals(this.hostname, host.hostname);
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.hostname);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ip", (Object)this.ip).add("hostname", (Object)this.hostname).toString();
    }

    public static class Builder {
        private String ip;
        private String hostname;

        private Builder() {
        }

        public Builder withIp(String ip) {
            this.ip = Objects.requireNonNull(ip);
            return this;
        }

        public Builder withHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Host build() {
            return new Host(this);
        }
    }
}

