/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.legacy;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.support.hops.VertexHopCriteria;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Edge;
import org.opennms.features.topology.api.topo.GraphProvider;
import org.opennms.features.topology.api.topo.TopologyProviderInfo;
import org.opennms.features.topology.api.topo.Vertex;
import org.opennms.netmgt.graph.api.ImmutableGraph;
import org.opennms.netmgt.graph.api.VertexRef;
import org.opennms.netmgt.graph.api.focus.Focus;
import org.opennms.netmgt.graph.api.generic.GenericEdge;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.api.info.DefaultGraphInfo;
import org.opennms.netmgt.graph.api.info.GraphInfo;
import org.opennms.netmgt.graph.domain.AbstractDomainGraph;
import org.opennms.netmgt.graph.provider.legacy.LegacyEdge;
import org.opennms.netmgt.graph.provider.legacy.LegacyVertex;

public class LegacyGraph
extends AbstractDomainGraph<LegacyVertex, LegacyEdge> {
    public static GraphInfo getGraphInfo(GraphProvider topoGraphProvider) {
        TopologyProviderInfo delegateInfo = topoGraphProvider.getTopologyProviderInfo();
        DefaultGraphInfo graphInfo = new DefaultGraphInfo(topoGraphProvider.getNamespace());
        graphInfo.setDescription(delegateInfo.getDescription());
        graphInfo.setLabel(delegateInfo.getName());
        return graphInfo;
    }

    public static LegacyGraph getLegacyGraphFromTopoGraphProvider(GraphProvider topoGraphProvider) {
        return new LegacyGraph(LegacyGraph.getImmutableGraphFromTopoGraphProvider(topoGraphProvider).asGenericGraph());
    }

    public static ImmutableGraph<?, ?> getImmutableGraphFromTopoGraphProvider(GraphProvider topoGraphProvider) {
        topoGraphProvider.refresh();
        BackendGraph currentGraph = topoGraphProvider.getCurrentGraph();
        GenericGraph.GenericGraphBuilder builder = GenericGraph.builder();
        ((GenericGraph.GenericGraphBuilder)builder.graphInfo(LegacyGraph.getGraphInfo(topoGraphProvider)).id(currentGraph.getNamespace())).property("enrichment.resolveNodes", (Object)true).property("enrichment.defaultStatus", (Object)true);
        currentGraph.getVertices(new Criteria[0]).forEach(legacyVertex -> {
            LegacyVertex domainVertex = new LegacyVertex((Vertex)legacyVertex);
            GenericVertex genericVertex = domainVertex.asGenericVertex();
            builder.addVertex(genericVertex);
        });
        currentGraph.getEdges(new Criteria[0]).forEach(legacyEdge -> {
            LegacyEdge domainEdge = new LegacyEdge((Edge)legacyEdge);
            GenericEdge genericEdge = domainEdge.asGenericEdge();
            builder.addEdge(genericEdge);
        });
        Set focus = topoGraphProvider.getDefaults().getCriteria().stream().filter(c -> VertexHopCriteria.class.isAssignableFrom(c.getClass())).map(c -> (VertexHopCriteria)c).flatMap(c -> c.getVertices().stream()).map(v -> new VertexRef(v.getNamespace(), v.getId())).collect(Collectors.toSet());
        builder.focus(new Focus("SELECTION", (List)Lists.newArrayList(focus)));
        return builder.build();
    }

    public LegacyGraph(GenericGraph genericGraph) {
        super(genericGraph);
    }

    protected ImmutableGraph<LegacyVertex, LegacyEdge> convert(GenericGraph graph) {
        return new LegacyGraph(graph);
    }

    protected LegacyVertex convert(GenericVertex vertex) {
        return new LegacyVertex(vertex);
    }

    protected LegacyEdge convert(GenericEdge edge) {
        return new LegacyEdge(edge);
    }
}

