/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.listener;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.xml.XmlFrameDecoder;
import io.netty.handler.logging.LoggingHandler;
import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.config.api.EventdConfig;
import org.opennms.netmgt.eventd.listener.XmlEventProcessor;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpListener {
    private static final Logger LOG = LoggerFactory.getLogger(UdpListener.class);
    private EventLoopGroup bossGroup;
    private ChannelFuture future;
    private final EventIpcManager eventIpcManager;
    private final EventdConfig config;

    public UdpListener(EventdConfig config, EventIpcManager eventIpcManager) {
        this.config = Objects.requireNonNull(config);
        this.eventIpcManager = Objects.requireNonNull(eventIpcManager);
    }

    public void start() throws InterruptedException {
        this.bossGroup = new NioEventLoopGroup();
        Bootstrap b = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.bossGroup)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_RCVBUF, (Object)Integer.MAX_VALUE)).handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

            protected void initChannel(DatagramChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler()});
                ch.pipeline().addLast(new ChannelHandler[]{new MessageToMessageDecoder<DatagramPacket>(){

                    protected void decode(ChannelHandlerContext ctx, DatagramPacket msg, List<Object> out) throws Exception {
                        msg.retain();
                        out.add(msg.content());
                    }
                }});
                ch.pipeline().addLast(new ChannelHandler[]{new XmlFrameDecoder(Integer.MAX_VALUE)});
                ch.pipeline().addLast(new ChannelHandler[]{new XmlEventProcessor((EventForwarder)UdpListener.this.eventIpcManager)});
            }
        });
        this.future = b.bind(this.config.getUDPIpAddress(), this.config.getUDPPort()).await();
    }

    public void stop() throws InterruptedException {
        LOG.info("Closing channel...");
        ChannelFuture cf = this.future.channel().closeFuture();
        LOG.info("Closing boss group...");
        this.bossGroup.shutdownGracefully().sync();
        cf.sync();
    }
}

