/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.dao.api;

import com.atlassian.oai.validator.report.MessageResolver;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.schema.SchemaValidator;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.HashMap;
import java.util.Map;
import org.opennms.features.config.dao.api.util.OpenAPIDeserializer;
import org.opennms.features.config.dao.api.util.OpenAPISerializer;
import org.opennms.features.config.exception.SchemaNotFoundException;
import org.opennms.features.config.exception.ValidationException;

public class ConfigDefinition {
    public static final String TOP_LEVEL_ELEMENT_NAME_TAG = "topLevelElement";
    public static final String XSD_FILENAME_TAG = "xsdFilename";
    public static final String ELEMENT_NAME_TO_VALUE_NAME_TAG = "elementNameToValueName";
    public static final String DEFAULT_CONFIG_ID = "default";
    private String configName;
    private boolean allowMultiple;
    private Map<String, Object> meta = new HashMap<String, Object>();
    @JsonSerialize(using=OpenAPISerializer.class)
    @JsonDeserialize(using=OpenAPIDeserializer.class)
    protected OpenAPI schema;

    @JsonCreator
    public ConfigDefinition(@JsonProperty(value="configName") String configName, @JsonProperty(value="allowMultiple") Boolean allowMultiple) {
        this.configName = configName;
        this.allowMultiple = allowMultiple == null ? false : allowMultiple;
    }

    public OpenAPI getSchema() {
        return this.schema;
    }

    public void setSchema(OpenAPI schema) {
        this.schema = schema;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public Map<String, Object> getMeta() {
        return this.meta;
    }

    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    public Object getMetaValue(String key) {
        return this.meta.get(key);
    }

    public void setMetaValue(String key, Object value) {
        this.meta.put(key, value);
    }

    public boolean getAllowMultiple() {
        return this.allowMultiple;
    }

    public void setAllowMultiple(boolean allowMultiple) {
        this.allowMultiple = allowMultiple;
    }

    @JsonIgnore
    public void validate(String json) {
        Schema topSchema;
        String topSchemaName = (String)this.meta.get(TOP_LEVEL_ELEMENT_NAME_TAG);
        if (topSchemaName == null) {
            topSchemaName = this.configName;
        }
        if (this.getSchema() == null) {
            throw new SchemaNotFoundException("Empty schema!");
        }
        SchemaValidator validator = new SchemaValidator(this.getSchema(), new MessageResolver());
        ValidationReport report = validator.validate(json, topSchema = new Schema().$ref("#/components/schemas/" + topSchemaName), null);
        if (report.hasErrors()) {
            throw new ValidationException(report);
        }
    }
}

