/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.commands;

import com.google.common.base.Strings;
import java.lang.management.ManagementFactory;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.support.table.HAlign;
import org.apache.karaf.shell.support.table.Row;
import org.apache.karaf.shell.support.table.ShellTable;
import org.opennms.netmgt.dao.api.NodeDao;

@Command(scope="opennms", name="collectd-schedule", description="Displays the scheduled data-collection tasks.")
@Service
public class CollectdScheduleCommand
implements Action {
    @Option(name="-s", aliases={"--services"}, description="Show number of scheduled collectable services, 0 for all", required=false, multiValued=false)
    private Integer services = null;
    @Option(name="-o", aliases={"--order"}, description="Sort by given column", required=false, multiValued=false)
    private String order = "nextRunAbsoluteMs";
    @Option(name="-c", aliases={"--columns"}, description="Comma-seperated list of columns to be displayed", required=false, multiValued=false)
    private String columns = null;
    @Option(name="-d", aliases={"--desc"}, description="Descending order", required=false, multiValued=false)
    private Boolean descendingOrder = false;
    @Option(name="--no-ellipsis", description="wrap table rows")
    boolean noEllipsis;
    @Reference(optional=true)
    Terminal terminal;
    final Map<String, ColumnDef> columnDefs = new LinkedHashMap<String, ColumnDef>();
    final Map<Integer, String> nodeCache = new TreeMap<Integer, String>();
    final Map<Integer, String> locationCache = new TreeMap<Integer, String>();
    @Reference
    public NodeDao nodeDao;

    public CollectdScheduleCommand() {
        this.columnDefs.put("nodeId", new ColumnDef(Comparator.comparingInt(c -> (Integer)c.get("nodeId")), HAlign.right));
        this.columnDefs.put("nodeLocation", new ColumnDef((a, b) -> {
            String aString = this.locationCache.computeIfAbsent((Integer)a.get("nodeId"), nodeId -> this.nodeDao.getLocationForId(nodeId));
            String bString = this.locationCache.computeIfAbsent((Integer)b.get("nodeId"), nodeId -> this.nodeDao.getLocationForId(nodeId));
            return bString.compareTo(aString);
        }, HAlign.left));
        this.columnDefs.put("nodeLabel", new ColumnDef((a, b) -> {
            String aString = this.nodeCache.computeIfAbsent((Integer)a.get("nodeId"), nodeId -> this.nodeDao.getLabelForId(nodeId));
            String bString = this.nodeCache.computeIfAbsent((Integer)b.get("nodeId"), nodeId -> this.nodeDao.getLabelForId(nodeId));
            return bString.compareTo(aString);
        }, HAlign.left));
        this.columnDefs.put("ipAddress", new ColumnDef(Comparator.comparing(c -> (String)c.get("ipAddress")), HAlign.center));
        this.columnDefs.put("package", new ColumnDef(Comparator.comparingLong(c -> (Long)c.get("package")), HAlign.center));
        this.columnDefs.put("service", new ColumnDef(Comparator.comparingLong(c -> (Long)c.get("service")), HAlign.center));
        this.columnDefs.put("intervalMs", new ColumnDef(Comparator.comparingLong(c -> (Long)c.get("intervalMs")), HAlign.right));
        this.columnDefs.put("lastRunMs", new ColumnDef(Comparator.comparingLong(c -> (Long)c.get("lastRunMs")), HAlign.right));
        this.columnDefs.put("nextRunMs", new ColumnDef(Comparator.comparingLong(c -> (Long)c.get("nextRunMs")), HAlign.right));
        this.columnDefs.put("lastRunAbsoluteMs", new ColumnDef(Comparator.comparingLong(c -> (Long)c.get("lastRunAbsoluteMs")), HAlign.right));
        this.columnDefs.put("nextRunAbsoluteMs", new ColumnDef(Comparator.comparingLong(c -> (Long)c.get("nextRunAbsoluteMs")), HAlign.right));
    }

    private void printColumns() {
        System.out.printf("Column '%s' does not exist. Available columns are:\n", this.order);
        for (String columnName : this.columnDefs.keySet()) {
            System.out.printf("  %s\n", columnName);
        }
    }

    public Void execute() throws MalformedObjectNameException, ReflectionException, AttributeNotFoundException, InstanceNotFoundException, MBeanException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = new ObjectName("OpenNMS:Name=Collectd");
        String[] columnArr = this.columnDefs.keySet().toArray(new String[0]);
        if (!mBeanServer.isRegistered(objectName)) {
            System.out.println("Error accessing Collectd mBean");
            return null;
        }
        if (!Strings.isNullOrEmpty((String)this.columns)) {
            if (this.services == null) {
                System.out.println("Option --columns/-c can only be used in combination with --schedule/-s.");
                return null;
            }
            if (!Strings.isNullOrEmpty((String)this.columns)) {
                String[] arr;
                for (String column : arr = this.columns.split(",")) {
                    if (this.columnDefs.keySet().contains(column)) continue;
                    this.printColumns();
                    return null;
                }
                columnArr = arr;
            }
        }
        if (this.services != null && !this.columnDefs.keySet().contains(this.order)) {
            this.printColumns();
            return null;
        }
        Long currentTimeMillis = null;
        System.out.printf("Active Threads: %d\n", (long)((Long)mBeanServer.getAttribute(objectName, "ActiveThreads")));
        System.out.printf("Collectable Service Count: %d\n", (long)((Long)mBeanServer.getAttribute(objectName, "CollectableServiceCount")));
        System.out.printf("Core Pool Threads: %d\n", (long)((Long)mBeanServer.getAttribute(objectName, "CorePoolThreads")));
        System.out.printf("Max Pool Threads: %d\n", (Long)mBeanServer.getAttribute(objectName, "MaxPoolThreads"));
        System.out.printf("Num Pool Threads:%d \n", (long)((Long)mBeanServer.getAttribute(objectName, "NumPoolThreads")));
        System.out.printf("Peak Pool Threads: %d\n", (long)((Long)mBeanServer.getAttribute(objectName, "PeakPoolThreads")));
        System.out.printf("Task Completion Ratio: %,.5f\n", (double)((Double)mBeanServer.getAttribute(objectName, "TaskCompletionRatio")));
        System.out.printf("Task Queue Pending Count: %d\n", (long)((Long)mBeanServer.getAttribute(objectName, "TaskQueuePendingCount")));
        System.out.printf("Task Queue Remaining Capacity: %d\n", (long)((Long)mBeanServer.getAttribute(objectName, "TaskQueueRemainingCapacity")));
        System.out.printf("Tasks Completed: %d\n", (long)((Long)mBeanServer.getAttribute(objectName, "TasksCompleted")));
        System.out.printf("Tasks Total: %d\n", (long)((Long)mBeanServer.getAttribute(objectName, "TasksTotal")));
        if (this.services != null) {
            TabularData tabularData = (TabularData)mBeanServer.getAttribute(objectName, "Schedule");
            if (this.services < 0) {
                System.out.printf("\nOption --services/-s must be zero or positive.\n", new Object[0]);
                return null;
            }
            if (tabularData.isEmpty()) {
                System.out.printf("\nNo Collectd scheduled services found\n", new Object[0]);
                return null;
            }
            ShellTable table = new ShellTable();
            if (!this.noEllipsis && this.terminal != null && this.terminal.getWidth() > 0) {
                table.size(this.terminal.getWidth() - 1);
            }
            for (String column : columnArr) {
                table.column(column).align(this.columnDefs.get((Object)column).alignment);
            }
            Comparator<CompositeData> compositeDataComparator = this.descendingOrder != false ? this.columnDefs.get((Object)this.order).comparator.reversed() : this.columnDefs.get((Object)this.order).comparator;
            Stream<CompositeData> compositeDataStream = tabularData.values().stream().sorted(compositeDataComparator);
            if (this.services > 0) {
                compositeDataStream = compositeDataStream.limit(this.services.intValue());
            }
            List compositeDataList = compositeDataStream.collect(Collectors.toList());
            for (CompositeData compositeData : compositeDataList) {
                if (currentTimeMillis == null) {
                    currentTimeMillis = (Long)compositeData.get("lastRunAbsoluteMs") - (Long)compositeData.get("lastRunMs");
                }
                Row row = table.addRow();
                for (String column : columnArr) {
                    if (column.equals("nodeLabel")) {
                        String nodeLabel = this.nodeCache.computeIfAbsent((Integer)compositeData.get("nodeId"), nodeId -> this.nodeDao.getLabelForId(nodeId));
                        row.addContent(new Object[]{nodeLabel});
                        continue;
                    }
                    if (column.equals("nodeLocation")) {
                        String nodeLocation = this.locationCache.computeIfAbsent((Integer)compositeData.get("nodeId"), nodeId -> this.nodeDao.getLocationForId(nodeId));
                        row.addContent(new Object[]{nodeLocation});
                        continue;
                    }
                    row.addContent(new Object[]{compositeData.get(column)});
                }
            }
            System.out.printf("Current Time Millis: %d\n\n", currentTimeMillis);
            table.print(System.out);
        }
        return null;
    }

    private class ColumnDef {
        private final Comparator<CompositeData> comparator;
        private final HAlign alignment;

        public ColumnDef(Comparator<CompositeData> comparator, HAlign alignment) {
            this.comparator = comparator;
            this.alignment = alignment;
        }
    }
}

