/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.activemq.shell;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.utils.StringUtils;
import org.opennms.features.activemq.broker.api.ManagedBroker;
import org.opennms.features.activemq.broker.api.ManagedDestination;

@Command(scope="opennms", name="activemq-stats", description="Show statistics for the embedded ActiveMQ broker.")
@Service
public class Stats
implements Action {
    @Reference(optional=true)
    private ManagedBroker broker;
    @Option(name="-n", aliases={"--top-n"}, description="Only show the Top N destinations (set to 0 to show all)")
    private int topNDests = 5;
    @Option(name="-a", aliases={"--show-advisory"}, description="Show advisory topics.")
    private boolean showAdvisoryTopics = false;

    public Object execute() {
        Comparator<ManagedDestination> comparator;
        if (this.broker == null) {
            System.out.println("(No broker available.)");
            return null;
        }
        System.out.println("Broker statistics:");
        System.out.printf("\tConnections: %d\n", this.broker.getCurrentConnections());
        System.out.printf("\tMemory percent usage: %d%%\n", this.broker.getMemoryPercentUsage());
        System.out.printf("\tMemory usage: %s\n", StringUtils.getHumanReadableByteCount((long)this.broker.getMemoryUsage(), (boolean)false));
        System.out.printf("\tMemory limit: %s\n", StringUtils.getHumanReadableByteCount((long)this.broker.getMemoryLimit(), (boolean)false));
        System.out.print("Destination statistics ");
        if (this.topNDests > 0) {
            System.out.printf("(top %d):\n", this.topNDests);
            comparator = Comparator.comparing(ManagedDestination::getMessageCount).thenComparing(d -> d.getEnqueueCount() + d.getDequeueCount()).reversed().thenComparing(ManagedDestination::getName);
        } else {
            System.out.println("(All):");
            comparator = Comparator.comparing(ManagedDestination::getName);
        }
        List dests = this.broker.getDestinations().stream().filter(d -> !d.getName().startsWith("ActiveMQ.Advisory") || this.showAdvisoryTopics).sorted(comparator).limit(this.topNDests > 0 ? (long)this.topNDests : Integer.MAX_VALUE).collect(Collectors.toList());
        for (ManagedDestination dest : dests) {
            System.out.printf("\t%s (%s)\n", dest.getName(), Stats.getTypeName(dest));
            System.out.printf("\t\tMessage count: %d\n", dest.getMessageCount());
            System.out.printf("\t\tEnqueue count: %s\n", dest.getEnqueueCount());
            System.out.printf("\t\tDequeue count: %s\n", dest.getDequeueCount());
            System.out.printf("\t\tCursor full: %s\n", dest.isCursorFull());
        }
        return null;
    }

    private static String getTypeName(ManagedDestination dest) {
        StringBuilder sb = new StringBuilder();
        if (dest.isQueue()) {
            sb.append("Queue");
        } else if (dest.isTopic()) {
            sb.append("Topic");
        } else {
            sb.append("Unknown");
        }
        if (dest.isTemporary()) {
            sb.append("(temp)");
        }
        return sb.toString();
    }
}

