/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.osgi.del;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.felix.cm.NotCachablePersistenceManager;
import org.apache.felix.cm.PersistenceManager;
import org.opennms.features.config.osgi.del.MigratedServices;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class CmPersistenceManagerDelegator
implements NotCachablePersistenceManager {
    private final BundleContext context;
    private final PersistenceManagerHolder cmManager = new PersistenceManagerHolder("org.opennms.features.config.osgi.cm.CmPersistenceManager");
    private final PersistenceManagerHolder fileManager = new PersistenceManagerHolder("org.apache.felix.cm.file.FilePersistenceManager");

    public CmPersistenceManagerDelegator(BundleContext context) {
        this.context = context;
    }

    public boolean exists(String pid) {
        return this.getDelegate(pid).exists(pid);
    }

    public Enumeration getDictionaries() throws IOException {
        ArrayList dictionaries = new ArrayList();
        this.ensurePersistenceManagerIsAvailable(this.fileManager);
        dictionaries.addAll(Collections.list(this.fileManager.persistenceManager.getDictionaries()));
        if (this.cmManager.persistenceManager != null) {
            dictionaries.addAll(Collections.list(this.cmManager.persistenceManager.getDictionaries()));
        }
        return Collections.enumeration(dictionaries);
    }

    public Dictionary load(String pid) throws IOException {
        return this.getDelegate(pid).load(pid);
    }

    public void store(String pid, Dictionary props) throws IOException {
        this.getDelegate(pid).store(pid, props);
    }

    public void delete(String pid) throws IOException {
        this.getDelegate(pid).delete(pid);
    }

    private PersistenceManager getDelegate(String pid) {
        PersistenceManagerHolder pm = MigratedServices.isMigrated(pid) ? this.cmManager : this.fileManager;
        this.ensurePersistenceManagerIsAvailable(pm);
        return pm.persistenceManager;
    }

    private void ensurePersistenceManagerIsAvailable(PersistenceManagerHolder pm) {
        if (pm.persistenceManager != null) {
            return;
        }
        pm.persistenceManager = this.findPersistenceManager(pm.className);
    }

    private PersistenceManager findPersistenceManager(String className) {
        try {
            return this.context.getServiceReferences(PersistenceManager.class, null).stream().map(arg_0 -> ((BundleContext)this.context).getService(arg_0)).filter(s -> className.equals(s.getClass().getName())).findAny().orElseThrow(() -> new IllegalStateException("Cannot find " + className));
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class PersistenceManagerHolder {
        PersistenceManager persistenceManager;
        final String className;

        PersistenceManagerHolder(String className) {
            this.className = className;
        }
    }
}

