/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.snmptrap;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpVersion;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.VarbindType;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.xml.event.Parm;

public class SnmpTrapConfig {
    private String enterpriseId;
    private int specific = -1;
    private int generic = 6;
    private SnmpVersion version = SnmpVersion.V1;
    private String community;
    private InetAddress hostAddress;
    private InetAddress destinationAddress;
    private int destinationPort = 0;
    private List<Parm> parameters = new ArrayList<Parm>();

    public String getEnterpriseId() {
        return this.enterpriseId;
    }

    public int getSpecific() {
        return this.specific;
    }

    public int getGeneric() {
        return this.generic;
    }

    public SnmpVersion getVersion() {
        return this.version;
    }

    public String getCommunity() {
        return this.community;
    }

    public InetAddress getDestinationAddress() {
        return this.destinationAddress;
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    public List<Parm> getParameters() {
        return this.parameters;
    }

    public String getParameterValue(String parameterName) {
        for (Parm p : this.getParameters()) {
            if (!p.getParmName().equals(parameterName)) continue;
            return p.getValue().getContent();
        }
        return null;
    }

    public InetAddress getHostAddress() {
        return this.hostAddress;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public void setSpecific(int specific) {
        this.specific = specific;
    }

    public void setGeneric(int generic) {
        this.generic = generic;
    }

    public void setVersion(SnmpVersion version) {
        this.version = version;
    }

    public void setCommunity(String community) {
        this.community = community;
    }

    public void setDestinationAddress(InetAddress destinationAddress) {
        this.destinationAddress = destinationAddress;
    }

    public void setDestinationPort(int destinationPort) {
        this.destinationPort = destinationPort;
    }

    public void setParameters(List<Parm> parameters) {
        this.parameters = parameters;
    }

    public void setHostAddress(InetAddress hostAddress) {
        this.hostAddress = hostAddress;
    }

    public boolean hasSpecific() {
        return this.specific != -1;
    }

    public boolean hasGeneric() {
        return this.generic != -1;
    }

    public void addParameter(String parameterName, String parameterValue, String parameterType) {
        Parm p = new Parm(parameterName, parameterValue);
        p.getValue().setType(parameterType);
        this.parameters.add(p);
    }

    public SnmpAgentConfig getAgentConfig() {
        SnmpAgentConfig config = SnmpPeerFactory.getInstance().getAgentConfig(this.destinationAddress, this.version.intValue());
        if (this.destinationPort > 0) {
            config.setPort(this.destinationPort);
        }
        if ((this.version.isV1() || this.version.isV2()) && this.community != null) {
            config.setReadCommunity(this.community);
        }
        return config;
    }

    public boolean isValid() {
        if (this.version.isV1()) {
            for (Parm p : this.parameters) {
                if (!p.getValue().getType().equals(VarbindType.TYPE_SNMP_COUNTER64.toString())) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SnmpTrapConfig[").append("enterpriseId=").append(this.enterpriseId).append(", generic=").append(this.generic).append(", specific=").append(this.specific).append(", version=").append((Object)this.version).append(", community=").append(this.community).append(", hostAddress=").append(this.hostAddress.getHostAddress()).append(", destinationAddress=").append(this.destinationAddress.getHostAddress()).append(", destinationPort=").append(this.destinationPort).append(", parameters={");
        for (int i = 0; i < this.getParameters().size(); ++i) {
            Parm p = this.getParameters().get(i);
            sb.append(p.getParmName()).append("(").append(p.getValue().getType()).append(")='").append(p.getValue().getContent()).append("'");
            if (i >= this.getParameters().size() - 1) continue;
            sb.append(", ");
        }
        sb.append("}]");
        return sb.toString();
    }
}

