/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.common.NetworkNode;

public class NodeTypeEnums {
    public static final short EntryPointNode = 10;
    public static final short ReteNode = 20;
    public static final short ObjectTypeNode = 30;
    public static final short AlphaNode = 40;
    public static final short WindowNode = 60;
    public static final short RightInputAdapterNode = 71;
    public static final short ObjectSource = 80;
    public static final short QueryTerminalNode = 91;
    public static final short RuleTerminalNode = 101;
    public static final short LeftTupleSource = 111;
    public static final short LeftInputAdapterNode = 120;
    public static final short EvalConditionNode = 131;
    public static final short TimerConditionNode = 133;
    public static final short AsyncSendNode = 135;
    public static final short AsyncReceiveNode = 137;
    public static final short QueryRiaFixerNode = 141;
    public static final short FromNode = 151;
    public static final short ReactiveFromNode = 153;
    public static final short UnificationNode = 165;
    public static final short QueryElementNode = 165;
    public static final short ConditionalBranchNode = 167;
    public static final short BetaNode = 171;
    public static final short JoinNode = 181;
    public static final short NotNode = 191;
    public static final short ExistsNode = 201;
    public static final short AccumulateNode = 211;
    public static final short ForallNotNode = 221;
    public static final short ElseNode = 231;
    public static final short OperatorNode = 19;

    public static boolean isObjectSource(NetworkNode node) {
        return node.getType() < 80;
    }

    public static boolean isObjectSink(NetworkNode node) {
        return node.getType() % 2 == 0;
    }

    public static boolean isLeftTupleSource(NetworkNode node) {
        return node.getType() > 111;
    }

    public static boolean isBetaNode(NetworkNode node) {
        return node.getType() > 171;
    }

    public static boolean isTerminalNode(NetworkNode node) {
        return node.getType() == 91 || node.getType() == 101;
    }

    public static boolean isLeftTupleSink(NetworkNode node) {
        return node.getType() % 2 != 0;
    }

    public static boolean isEndNode(NetworkNode node) {
        return NodeTypeEnums.isTerminalNode(node) || 71 == node.getType();
    }

    public static boolean isLeftTupleNode(NetworkNode node) {
        return NodeTypeEnums.isLeftTupleSource(node) || NodeTypeEnums.isLeftTupleSink(node);
    }

    public static boolean hasNodeMemory(NetworkNode node) {
        return node.getType() == 151 || node.getType() == 153 || node.getType() == 211;
    }
}

