/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.MemoryFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.phreak.BuildtimeSegmentUtilities;
import org.drools.core.phreak.LazyPhreakBuilder;
import org.drools.core.phreak.PhreakBuilder;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.rule.constraint.QueryNameConstraint;

public class RuntimeSegmentUtilities {
    public static SegmentMemory getOrCreateSegmentMemory(LeftTupleNode node, ReteEvaluator reteEvaluator) {
        SegmentMemory smem = reteEvaluator.getNodeMemory((MemoryFactory)((Object)node)).getSegmentMemory();
        if (smem != null) {
            return smem;
        }
        LeftTupleNode segmentRoot = BuildtimeSegmentUtilities.findSegmentRoot(node);
        smem = RuntimeSegmentUtilities.restoreSegmentFromPrototype(reteEvaluator, segmentRoot);
        if (smem != null) {
            if (NodeTypeEnums.isBetaNode(segmentRoot) && ((BetaNode)segmentRoot).isRightInputIsRiaNode()) {
                RuntimeSegmentUtilities.createRiaSegmentMemory((BetaNode)segmentRoot, reteEvaluator);
            }
            return smem;
        }
        return LazyPhreakBuilder.createSegmentMemory(reteEvaluator, segmentRoot);
    }

    private static SegmentMemory restoreSegmentFromPrototype(ReteEvaluator reteEvaluator, LeftTupleNode segmentRoot) {
        SegmentMemory.SegmentPrototype proto = reteEvaluator.getKnowledgeBase().getSegmentPrototype(segmentRoot);
        if (proto == null || proto.getNodesInSegment() == null) {
            return null;
        }
        LeftTupleNode lastNode = proto.getNodesInSegment()[proto.getNodesInSegment().length - 1];
        SegmentMemory smem = null;
        if (NodeTypeEnums.isTerminalNode(lastNode)) {
            PathMemory pmem = (PathMemory)reteEvaluator.getNodeMemories().peekNodeMemory(lastNode);
            if (pmem == null) {
                pmem = RuntimeSegmentUtilities.initializePathMemory(reteEvaluator, (PathEndNode)lastNode);
            }
            smem = pmem.getSegmentMemories()[proto.getPos()];
        }
        if (smem == null) {
            smem = reteEvaluator.getKnowledgeBase().createSegmentFromPrototype(reteEvaluator, proto);
        }
        RuntimeSegmentUtilities.updateRiaAndTerminalMemory(smem, proto, reteEvaluator);
        return smem;
    }

    public static SegmentMemory getQuerySegmentMemory(ReteEvaluator reteEvaluator, LeftTupleSource segmentRoot, QueryElementNode queryNode) {
        LeftInputAdapterNode liaNode = RuntimeSegmentUtilities.getQueryLiaNode(queryNode.getQueryElement().getQueryName(), RuntimeSegmentUtilities.getQueryOtn(segmentRoot));
        LeftInputAdapterNode.LiaNodeMemory liam = reteEvaluator.getNodeMemory(liaNode);
        SegmentMemory querySmem = liam.getSegmentMemory();
        if (querySmem == null) {
            querySmem = RuntimeSegmentUtilities.getOrCreateSegmentMemory(liaNode, reteEvaluator);
        }
        return querySmem;
    }

    static RightInputAdapterNode createRiaSegmentMemory(BetaNode betaNode, ReteEvaluator reteEvaluator) {
        RightInputAdapterNode riaNode = (RightInputAdapterNode)betaNode.getRightInput();
        LeftTupleSource subnetworkLts = riaNode.getLeftTupleSource();
        while (subnetworkLts.getLeftTupleSource() != riaNode.getStartTupleSource()) {
            subnetworkLts = subnetworkLts.getLeftTupleSource();
        }
        Object rootSubNetwokrMem = reteEvaluator.getNodeMemory((MemoryFactory)((Object)subnetworkLts));
        SegmentMemory subNetworkSegmentMemory = rootSubNetwokrMem.getSegmentMemory();
        if (subNetworkSegmentMemory == null) {
            RuntimeSegmentUtilities.getOrCreateSegmentMemory(subnetworkLts, reteEvaluator);
        }
        return riaNode;
    }

    public static void createChildSegments(ReteEvaluator reteEvaluator, SegmentMemory smem, LeftTupleSinkPropagator sinkProp) {
        if (!smem.isEmpty()) {
            return;
        }
        for (LeftTupleSinkNode sink = sinkProp.getFirstLeftTupleSink(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            SegmentMemory childSmem = PhreakBuilder.isEagerSegmentCreation() ? RuntimeSegmentUtilities.createChildSegment(reteEvaluator, sink) : LazyPhreakBuilder.createChildSegment(reteEvaluator, sink);
            smem.add(childSmem);
        }
    }

    public static SegmentMemory createChildSegment(ReteEvaluator reteEvaluator, LeftTupleNode node) {
        Object memory = reteEvaluator.getNodeMemory((MemoryFactory)((Object)node));
        if (memory.getSegmentMemory() == null) {
            RuntimeSegmentUtilities.getOrCreateSegmentMemory(node, reteEvaluator);
        }
        return memory.getSegmentMemory();
    }

    private static void updateRiaAndTerminalMemory(SegmentMemory smem, SegmentMemory.SegmentPrototype proto, ReteEvaluator reteEvaluator) {
        for (PathEndNode pathEndNode : proto.getPathEndNodes()) {
            if (pathEndNode.getSegmentPrototypes()[proto.getPos()] == null) continue;
            PathMemory pmem = (PathMemory)reteEvaluator.getNodeMemories().peekNodeMemory(pathEndNode);
            if (pmem != null) {
                pmem.setSegmentMemory(smem.getPos(), smem);
            } else {
                pmem = (PathMemory)reteEvaluator.getNodeMemories().getNodeMemory((MemoryFactory)((Object)pathEndNode), reteEvaluator);
                pmem.setSegmentMemory(smem.getPos(), smem);
                RuntimeSegmentUtilities.initializePathMemory(reteEvaluator, pathEndNode, pmem);
            }
            smem.addPathMemory(pmem);
            if (!smem.isSegmentLinked()) continue;
            smem.notifyRuleLinkSegment(reteEvaluator);
        }
    }

    public static PathMemory initializePathMemory(ReteEvaluator reteEvaluator, PathEndNode pathEndNode) {
        PathMemory pmem = (PathMemory)reteEvaluator.getNodeMemories().getNodeMemory((MemoryFactory)((Object)pathEndNode), reteEvaluator);
        RuntimeSegmentUtilities.initializePathMemory(reteEvaluator, pathEndNode, pmem);
        return pmem;
    }

    public static void initializePathMemory(ReteEvaluator reteEvaluator, PathEndNode pathEndNode, PathMemory pmem) {
        if (pathEndNode.getEagerSegmentPrototypes() != null) {
            for (SegmentMemory.SegmentPrototype eager : pathEndNode.getEagerSegmentPrototypes()) {
                if (pmem.getSegmentMemories()[eager.getPos()] != null) continue;
                RuntimeSegmentUtilities.getOrCreateSegmentMemory(eager.getRootNode(), reteEvaluator);
            }
        }
    }

    private static ObjectTypeNode getQueryOtn(LeftTupleSource lts) {
        while (!(lts instanceof LeftInputAdapterNode)) {
            lts = lts.getLeftTupleSource();
        }
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)lts;
        ObjectSource os = liaNode.getObjectSource();
        while (!(os instanceof EntryPointNode)) {
            os = os.getParentObjectSource();
        }
        return ((EntryPointNode)os).getQueryNode();
    }

    private static LeftInputAdapterNode getQueryLiaNode(String queryName, ObjectTypeNode queryOtn) {
        for (ObjectSink sink : queryOtn.getObjectSinkPropagator().getSinks()) {
            AlphaNode alphaNode = (AlphaNode)sink;
            QueryNameConstraint nameConstraint = (QueryNameConstraint)alphaNode.getConstraint();
            if (!queryName.equals(nameConstraint.getQueryName())) continue;
            return (LeftInputAdapterNode)alphaNode.getObjectSinkPropagator().getSinks()[0];
        }
        throw new RuntimeException("Unable to find query '" + queryName + "'");
    }
}

