/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.headers;

import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramVisitor;

public class Inet4Header {
    public final int tos;
    public final int totalLength;
    public final int protocol;
    public final Inet4Address srcAddress;
    public final Inet4Address dstAddress;
    public final Integer srcPort;
    public final Integer dstPort;
    public final Integer tcpFlags;

    public Inet4Header(ByteBuf buffer) throws InvalidPacketException {
        int version_ihl = BufferUtils.uint8((ByteBuf)buffer);
        if (version_ihl >> 4 != 4) {
            throw new InvalidPacketException(buffer, "Expected IPv4 Header", new Object[0]);
        }
        int ihl = (version_ihl & 0xF) * 4;
        this.tos = BufferUtils.uint8((ByteBuf)buffer);
        this.totalLength = BufferUtils.uint16((ByteBuf)buffer);
        BufferUtils.skip((ByteBuf)buffer, (int)2);
        BufferUtils.skip((ByteBuf)buffer, (int)2);
        BufferUtils.skip((ByteBuf)buffer, (int)1);
        this.protocol = BufferUtils.uint8((ByteBuf)buffer);
        BufferUtils.skip((ByteBuf)buffer, (int)2);
        try {
            this.srcAddress = (Inet4Address)Inet4Address.getByAddress(BufferUtils.bytes((ByteBuf)buffer, (int)4));
            this.dstAddress = (Inet4Address)Inet4Address.getByAddress(BufferUtils.bytes((ByteBuf)buffer, (int)4));
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
        BufferUtils.skip((ByteBuf)buffer, (int)(ihl - 20));
        switch (this.protocol) {
            case 6: {
                this.srcPort = BufferUtils.uint16((ByteBuf)buffer);
                this.dstPort = BufferUtils.uint16((ByteBuf)buffer);
                BufferUtils.skip((ByteBuf)buffer, (int)8);
                this.tcpFlags = BufferUtils.uint16((ByteBuf)buffer) & 0x1FF;
                break;
            }
            case 17: 
            case 132: {
                this.srcPort = BufferUtils.uint16((ByteBuf)buffer);
                this.dstPort = BufferUtils.uint16((ByteBuf)buffer);
                this.tcpFlags = null;
                break;
            }
            case 1: 
            case 58: {
                this.srcPort = 0;
                this.dstPort = BufferUtils.uint16((ByteBuf)buffer);
                this.tcpFlags = null;
                break;
            }
            default: {
                this.srcPort = null;
                this.dstPort = null;
                this.tcpFlags = null;
            }
        }
    }

    public Inet4Header(int tos, int totalLength, int protocol, Inet4Address srcAddress, Inet4Address dstAddress, Integer srcPort, Integer dstPort, Integer tcpFlags) {
        this.tos = tos;
        this.totalLength = totalLength;
        this.protocol = protocol;
        this.srcAddress = srcAddress;
        this.dstAddress = dstAddress;
        this.srcPort = srcPort;
        this.dstPort = dstPort;
        this.tcpFlags = tcpFlags;
    }

    public Inet4Address getSrcAddress() {
        return this.srcAddress;
    }

    public Inet4Address getDstAddress() {
        return this.dstAddress;
    }

    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt32("tos", this.tos);
        bsonWriter.writeInt32("length", this.totalLength);
        bsonWriter.writeInt32("protocol", this.protocol);
        bsonWriter.writeStartDocument("src_ip");
        bsonWriter.writeString("address", this.srcAddress.getHostAddress());
        enr.getHostnameFor(this.srcAddress).ifPresent(hostname -> bsonWriter.writeString("hostname", hostname));
        bsonWriter.writeEndDocument();
        bsonWriter.writeStartDocument("dst_ip");
        bsonWriter.writeString("address", this.dstAddress.getHostAddress());
        enr.getHostnameFor(this.dstAddress).ifPresent(hostname -> bsonWriter.writeString("hostname", hostname));
        bsonWriter.writeEndDocument();
        if (this.srcPort != null) {
            bsonWriter.writeInt32("src_port", this.srcPort.intValue());
        }
        if (this.dstPort != null) {
            bsonWriter.writeInt32("dst_port", this.dstPort.intValue());
        }
        if (this.tcpFlags != null) {
            bsonWriter.writeInt32("tcp_flags", this.tcpFlags.intValue());
        }
        bsonWriter.writeEndDocument();
    }

    public void visit(SampleDatagramVisitor visitor) {
        visitor.accept(this);
    }
}

