/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.sblim.wbem.http.TrustAllKeyManager;
import org.sblim.wbem.http.TrustAllTrustManager;
import org.sblim.wbem.util.SessionProperties;

public class HttpSocketFactory {
    private static final String CLASSNAME = HttpSocketFactory.class.getName();
    private SSLSocketFactory iSslSocketFactory;
    private SocketFactory iDefaultSocketFactory;
    private ServerSocketFactory iDefaultServerSocketFactory;
    private SSLServerSocketFactory iSslServerSocketFactory;
    private SSLContext iSslContext;
    private static HttpSocketFactory iInstance = new HttpSocketFactory();
    Logger ilogger = SessionProperties.getGlobalProperties().getLogger();

    private HttpSocketFactory() {
    }

    public static HttpSocketFactory getInstance() {
        return iInstance;
    }

    public ServerSocketFactory getServerSocketFactory(boolean ssl, SessionProperties properties) {
        if (ssl) {
            return this.getSSLServerSocketFactory(properties);
        }
        return this.getServerSocketFactory();
    }

    public SocketFactory getSocketFactory(String protocol, SessionProperties properties) {
        String methodName = "getSocketFactory(String)";
        SocketFactory socketFactory = properties.getSocketFactory();
        if (this.ilogger.isLoggable(Level.FINER)) {
            this.ilogger.entering(CLASSNAME, methodName, protocol);
        }
        if (socketFactory == null) {
            if (protocol.equalsIgnoreCase("https")) {
                socketFactory = this.getSSLSocketFactory(properties);
            } else if (protocol.equalsIgnoreCase("http")) {
                socketFactory = this.getSocketFactory(properties);
            }
        }
        if (this.ilogger.isLoggable(Level.FINER)) {
            this.ilogger.exiting(CLASSNAME, methodName, socketFactory);
        }
        return socketFactory;
    }

    private SSLContext getSSLContext(SessionProperties properties) {
        String methodName = "getSSLContext()";
        if (this.ilogger.isLoggable(Level.FINER)) {
            this.ilogger.entering(CLASSNAME, methodName);
        }
        KeyManager[] allKeys = new KeyManager[]{new TrustAllKeyManager()};
        String provider = properties.getJSSEProvider();
        this.ilogger.log(Level.INFO, "Loading JSSE provider:" + provider);
        String protocolHandler = properties.getJSSEProtocolHandler();
        if (protocolHandler != null) {
            System.setProperty("java.protocol.handler.pkgs", protocolHandler);
        }
        try {
            Class<?> providerClass = Class.forName(provider);
            Provider securityProvider = (Provider)providerClass.newInstance();
            if (Security.getProvider(securityProvider.getName()) != null) {
                Security.removeProvider(securityProvider.getName());
            }
            Security.insertProviderAt(securityProvider, 1);
        }
        catch (Exception e) {
            if (this.ilogger.isLoggable(Level.SEVERE)) {
                this.ilogger.log(Level.SEVERE, "Unexpected exception while initializing JSSE provider: " + provider, e);
            }
            if (this.ilogger.isLoggable(Level.FINER)) {
                this.ilogger.exiting(CLASSNAME, methodName, null);
            }
            throw new RuntimeException(e);
        }
        String keyStorePath = properties.getKeystore();
        char[] keystorePassword = properties.getKeystorePassword();
        if (keystorePassword == null && this.ilogger.isLoggable(Level.WARNING)) {
            this.ilogger.log(Level.WARNING, "Unassigned KeyStore password");
        }
        if (keyStorePath == null && this.ilogger.isLoggable(Level.WARNING)) {
            this.ilogger.log(Level.WARNING, "Unassigned keystore path ");
        }
        if (this.ilogger.isLoggable(Level.FINER)) {
            this.ilogger.log(Level.FINER, "Loading keystore from :" + keyStorePath);
        }
        try {
            KeyManager[] keyManager = allKeys;
            try {
                KeyStore keystore = KeyStore.getInstance(properties.getKeystoreType());
                keystore.load(new FileInputStream(keyStorePath), keystorePassword);
                String certificates = properties.getJSSECertificate();
                if (this.ilogger.isLoggable(Level.FINER)) {
                    this.ilogger.log(Level.FINER, "Loading KeyManagerFactory with certificates from:" + certificates);
                }
                KeyManagerFactory keymanagerfactory = KeyManagerFactory.getInstance(certificates);
                if (this.ilogger.isLoggable(Level.FINER)) {
                    this.ilogger.log(Level.FINER, "Initializing KeyManagerFactory...");
                }
                keymanagerfactory.init(keystore, keystorePassword);
                if (this.ilogger.isLoggable(Level.FINER)) {
                    this.ilogger.log(Level.FINER, "Getting KeyManager...");
                }
                keyManager = keymanagerfactory.getKeyManagers();
            }
            catch (FileNotFoundException e) {
                if (this.ilogger.isLoggable(Level.WARNING)) {
                    this.ilogger.log(Level.WARNING, "Keystore file not found at location: " + keyStorePath, e);
                }
                keyManager = allKeys;
            }
            catch (IOException e) {
                if (this.ilogger.isLoggable(Level.WARNING)) {
                    this.ilogger.log(Level.WARNING, "exception while reading from keystore file", e);
                }
                keyManager = allKeys;
            }
            catch (CertificateException e) {
                if (this.ilogger.isLoggable(Level.WARNING)) {
                    this.ilogger.log(Level.WARNING, "problems with certificates while loading keystore", e);
                }
                keyManager = allKeys;
            }
            catch (UnrecoverableKeyException e) {
                if (this.ilogger.isLoggable(Level.SEVERE)) {
                    this.ilogger.log(Level.SEVERE, "Unexpected exception while loading keystore", e);
                }
                keyManager = allKeys;
            }
            catch (KeyStoreException e) {
                if (this.ilogger.isLoggable(Level.WARNING)) {
                    this.ilogger.log(Level.WARNING, "Unexpected exception while loading keystore", e);
                }
                keyManager = allKeys;
            }
            if (keystorePassword != null) {
                for (int i = 0; i < keystorePassword.length; ++i) {
                    keystorePassword[i] = '\u0000';
                }
            }
            String protocol = properties.getJSSEProtocol();
            if (this.ilogger.isLoggable(Level.FINER)) {
                this.ilogger.log(Level.FINER, "Getting SSLContext instance for: " + protocol);
            }
            this.iSslContext = SSLContext.getInstance(protocol);
            if (this.ilogger.isLoggable(Level.FINER)) {
                this.ilogger.log(Level.FINER, "Initializing SSLContext with default certificate manager (TrustAll)...");
            }
            this.iSslContext.init(keyManager, new X509TrustManager[]{new TrustAllTrustManager()}, null);
            if (this.ilogger.isLoggable(Level.FINER)) {
                this.ilogger.exiting(CLASSNAME, methodName, this.iSslContext);
            }
            return this.iSslContext;
        }
        catch (NoSuchAlgorithmException e) {
            if (this.ilogger.isLoggable(Level.SEVERE)) {
                this.ilogger.log(Level.SEVERE, "exception while initializing SSL context", e);
            }
            if (this.ilogger.isLoggable(Level.FINER)) {
                this.ilogger.exiting(CLASSNAME, methodName, null);
            }
            return null;
        }
        catch (KeyManagementException e) {
            if (this.ilogger.isLoggable(Level.SEVERE)) {
                this.ilogger.log(Level.SEVERE, "exception while initializing SSL context", e);
            }
            if (this.ilogger.isLoggable(Level.FINER)) {
                this.ilogger.exiting(CLASSNAME, methodName, null);
            }
            return null;
        }
    }

    protected synchronized SSLServerSocketFactory getSSLServerSocketFactory(SessionProperties properties) {
        String methodName = "getSSLServerSocketFactory()";
        SSLServerSocketFactory sssf = null;
        if (this.ilogger.isLoggable(Level.FINER)) {
            this.ilogger.entering(CLASSNAME, methodName);
        }
        if (this.iSslServerSocketFactory != null) {
            sssf = this.iSslServerSocketFactory;
        } else {
            if (this.iSslContext == null) {
                if (this.ilogger.isLoggable(Level.FINER)) {
                    this.ilogger.log(Level.FINER, "Creating default SSLContext...");
                }
                this.iSslContext = this.getSSLContext(properties);
            }
            if (this.iSslContext != null) {
                sssf = this.iSslContext.getServerSocketFactory();
            }
        }
        if (this.ilogger.isLoggable(Level.FINER)) {
            this.ilogger.exiting(CLASSNAME, methodName, sssf);
        }
        return sssf;
    }

    protected synchronized SSLSocketFactory getSSLSocketFactory(SessionProperties properties) {
        String methodName = "getSSLSocketFactory()";
        SSLSocketFactory sslsf = null;
        if (this.ilogger.isLoggable(Level.FINER)) {
            this.ilogger.entering(CLASSNAME, methodName);
        }
        if (this.iSslSocketFactory != null) {
            sslsf = this.iSslSocketFactory;
        } else {
            if (this.iSslContext == null) {
                if (this.ilogger.isLoggable(Level.FINER)) {
                    this.ilogger.log(Level.FINER, "Creating default SSLContext...");
                }
                this.iSslContext = this.getSSLContext(properties);
            }
            if (this.iSslContext != null) {
                if (this.ilogger.isLoggable(Level.FINER)) {
                    this.ilogger.log(Level.FINER, "Getting socket factory from SSLContext");
                }
                sslsf = this.iSslContext.getSocketFactory();
            }
        }
        if (this.ilogger.isLoggable(Level.FINER)) {
            this.ilogger.exiting(CLASSNAME, methodName, sslsf);
        }
        return sslsf;
    }

    protected synchronized ServerSocketFactory getServerSocketFactory() {
        String methodName = "getServerSocketFactory()";
        if (this.ilogger.isLoggable(Level.FINER)) {
            this.ilogger.entering(CLASSNAME, "getServerSocketFactory");
        }
        if (this.iDefaultServerSocketFactory == null) {
            if (this.ilogger.isLoggable(Level.FINER)) {
                this.ilogger.log(Level.FINER, "Using default ServerSocketFactory");
            }
            this.iDefaultServerSocketFactory = ServerSocketFactory.getDefault();
        }
        if (this.ilogger.isLoggable(Level.FINER)) {
            this.ilogger.exiting(CLASSNAME, methodName, this.iDefaultServerSocketFactory);
        }
        return this.iDefaultServerSocketFactory;
    }

    protected synchronized SocketFactory getSocketFactory(SessionProperties properties) {
        String methodName = " getSocketFactory()";
        if (this.ilogger.isLoggable(Level.FINER)) {
            this.ilogger.entering(CLASSNAME, methodName);
        }
        if (this.iDefaultSocketFactory == null) {
            if (this.ilogger.isLoggable(Level.FINER)) {
                this.ilogger.log(Level.FINER, "Using default SocketFactory");
            }
            this.iDefaultSocketFactory = SocketFactory.getDefault();
        }
        if (this.ilogger.isLoggable(Level.FINER)) {
            this.ilogger.exiting(CLASSNAME, methodName, this.iDefaultSocketFactory);
        }
        return this.iDefaultSocketFactory;
    }

    public synchronized void setSocketFactory(SocketFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null socket factory");
        }
        this.iDefaultSocketFactory = factory;
    }

    public synchronized void setSSLSocketFactory(SSLSocketFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null socket factory");
        }
        this.iSslSocketFactory = factory;
    }

    public synchronized void setSSLServerSocketFactory(SSLServerSocketFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null socket factory");
        }
        this.iSslServerSocketFactory = factory;
    }
}

