/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.math.BigInteger;
import org.sblim.wbem.cim.UnsignedInt16;
import org.sblim.wbem.cim.UnsignedInt32;
import org.sblim.wbem.cim.UnsignedInt8;

public class UnsignedInt64
extends Number
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4758276753882089604L;
    public static BigInteger MIN_VALUE = new BigInteger("0");
    public static BigInteger MAX_VALUE = new BigInteger("1").shiftLeft(64).subtract(new BigInteger("1"));
    private BigInteger iValue;

    public UnsignedInt64(byte pValue) {
        this.iValue = new BigInteger(Byte.toString(pValue));
        if (this.iValue.compareTo(MIN_VALUE) == -1 || this.iValue.compareTo(MAX_VALUE) == 1) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt64(short pValue) {
        this.iValue = new BigInteger(Short.toString(pValue));
        if (this.iValue.compareTo(MIN_VALUE) == -1 || this.iValue.compareTo(MAX_VALUE) == 1) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt64(int pValue) {
        this.iValue = new BigInteger(Integer.toString(pValue));
        if (this.iValue.compareTo(MIN_VALUE) == -1 || this.iValue.compareTo(MAX_VALUE) == 1) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt64(long pValue) {
        this.iValue = new BigInteger(Long.toString(pValue));
        if (this.iValue.compareTo(MIN_VALUE) == -1 || this.iValue.compareTo(MAX_VALUE) == 1) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt64(BigInteger pValue) {
        if (pValue == null) {
            throw new IllegalArgumentException("null bigInteger argument");
        }
        this.iValue = new BigInteger(pValue.toString());
        if (this.iValue.compareTo(MIN_VALUE) < 0 || this.iValue.compareTo(MAX_VALUE) > 0) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt64(String pValue) {
        if (pValue == null) {
            throw new IllegalArgumentException("null string argument");
        }
        if (pValue.trim().length() == 0) {
            throw new IllegalArgumentException("empty string argument");
        }
        this.iValue = new BigInteger(pValue);
        if (this.iValue.compareTo(MIN_VALUE) < 0 || this.iValue.compareTo(MAX_VALUE) > 0) {
            throw new IllegalArgumentException("Invalid value range. Value must be in a " + MIN_VALUE + ".." + MAX_VALUE + " range");
        }
    }

    public UnsignedInt64(UnsignedInt8 pValue) {
        this.iValue = new BigInteger(pValue.toString());
    }

    public UnsignedInt64(UnsignedInt16 pValue) {
        this.iValue = new BigInteger(pValue.toString());
    }

    public UnsignedInt64(UnsignedInt32 pValue) {
        this.iValue = new BigInteger(pValue.toString());
    }

    public UnsignedInt64(UnsignedInt64 pValue) {
        this.iValue = new BigInteger(pValue.toString());
    }

    public String toString() {
        return this.iValue.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof UnsignedInt64) {
            return this.iValue.compareTo(((UnsignedInt64)o).iValue) == 0;
        }
        return false;
    }

    public byte byteValue() {
        if (this.iValue.compareTo(new BigInteger(Byte.toString((byte)127))) > 0) {
            throw new NumberFormatException("Value range exceeded. The value " + this.iValue + " is not in the range of a Byte value which is inbetween " + -128 + " .. " + 127);
        }
        return this.iValue.byteValue();
    }

    public short shortValue() {
        if (this.iValue.compareTo(new BigInteger(Short.toString((short)Short.MAX_VALUE))) > 0) {
            throw new NumberFormatException("Value range exceeded. The value " + this.iValue + " is not in the range of a Short value which is inbetween " + Short.MIN_VALUE + " .. " + Short.MAX_VALUE);
        }
        return this.iValue.shortValue();
    }

    public int intValue() {
        if (this.iValue.compareTo(new BigInteger(Integer.toString(Integer.MAX_VALUE))) > 0) {
            throw new NumberFormatException("Value range exceeded. The value " + this.iValue + " is not in the range of a Integer value which is inbetween " + Integer.MIN_VALUE + " .. " + Integer.MAX_VALUE);
        }
        return this.iValue.intValue();
    }

    public long longValue() {
        if (this.iValue.compareTo(new BigInteger(Long.toString(Long.MAX_VALUE))) > 0) {
            throw new NumberFormatException("Value range exceeded. The value " + this.iValue + " is not in the range of a Long value which is inbetween " + Long.MIN_VALUE + " .. " + Long.MAX_VALUE);
        }
        return this.iValue.longValue();
    }

    public float floatValue() {
        if (this.iValue.floatValue() == Float.NEGATIVE_INFINITY || this.iValue.floatValue() == Float.POSITIVE_INFINITY) {
            throw new NumberFormatException("Value range exceeded. The value " + this.iValue + " is not in the range of a Float value which is inbetween " + Float.MIN_VALUE + " .. " + Float.MAX_VALUE);
        }
        return this.iValue.floatValue();
    }

    public double doubleValue() {
        if (this.iValue.doubleValue() == Double.NEGATIVE_INFINITY || this.iValue.doubleValue() == Double.POSITIVE_INFINITY) {
            throw new NumberFormatException("Value range exceeded. The value " + this.iValue + " is not in the range of a Double value which is inbetween " + Double.MIN_VALUE + " .. " + Double.MAX_VALUE);
        }
        return this.iValue.doubleValue();
    }

    public BigInteger bigIntValue() {
        return new BigInteger(this.iValue.toString());
    }

    public int hashCode() {
        return this.iValue.hashCode();
    }

    public Object clone() {
        return new UnsignedInt64(this.iValue);
    }
}

