/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMQualifiableElement;
import org.sblim.wbem.cim.CIMQualifier;

public class CIMParameter
extends CIMQualifiableElement
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4122732409934594730L;
    private CIMDataType iType;

    public CIMParameter() {
    }

    public CIMParameter(String pName) {
        super(pName);
    }

    public Object clone() {
        CIMParameter that = new CIMParameter(this.iName);
        that.iType = (CIMDataType)this.iType.clone();
        for (int i = 0; i < this.iQualifiers.size(); ++i) {
            that.iQualifiers.add(((CIMQualifier)this.iQualifiers.elementAt(i)).clone());
        }
        return that;
    }

    public int hashCode() {
        return this.iName.hashCode() + (this.iType != null ? this.iType.hashCode() : 0);
    }

    public int getSize() {
        if (this.iType != null) {
            return this.iType.getSize();
        }
        return -1;
    }

    public CIMDataType getType() {
        return this.iType;
    }

    public void setSize(int size) {
    }

    public void setType(CIMDataType pType) {
        if (pType == null) {
            throw new IllegalArgumentException("null data type argument");
        }
        this.iType = pType;
    }

    public String toMOF() {
        StringBuffer buff = new StringBuffer();
        if (this.iQualifiers.size() > 0) {
            buff.append(CIMParameter.vectorToMOFString(this.iQualifiers, false, 1));
            buff.append("\n\t\t");
        }
        buff.append(this.iType);
        buff.append(" ");
        buff.append(this.iName);
        return buff.toString();
    }

    public String toString() {
        return this.toMOF();
    }
}

