/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.adapter.stats;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpAsnInfoDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpGlobalIpRib;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpGlobalIpRibDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpIpRibLogDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpRouteInfo;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpRouteInfoDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpRpkiInfo;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpRpkiInfoDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpStatsByAsn;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpStatsByAsnDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpStatsByPeer;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpStatsByPeerDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpStatsByPrefix;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpStatsByPrefixDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpStatsIpOrigins;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpStatsIpOriginsDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpStatsPeerRib;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpStatsPeerRibDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.BmpUnicastPrefixDao;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.PrefixByAS;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.StatsByAsn;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.StatsByPeer;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.StatsByPrefix;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.StatsIpOrigins;
import org.opennms.netmgt.telemetry.protocols.bmp.persistence.api.StatsPeerRib;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BmpStatsAggregator {
    private static final Logger LOG = LoggerFactory.getLogger(BmpStatsAggregator.class);
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("UpdateStats-%d").build();
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(20, this.threadFactory);
    @Autowired
    private BmpIpRibLogDao bmpIpRibLogDao;
    @Autowired
    private BmpStatsByPeerDao bmpStatsByPeerDao;
    @Autowired
    private BmpStatsByAsnDao bmpStatsByAsnDao;
    @Autowired
    private BmpStatsByPrefixDao bmpStatsByPrefixDao;
    @Autowired
    private BmpUnicastPrefixDao bmpUnicastPrefixDao;
    @Autowired
    private BmpStatsPeerRibDao bmpStatsPeerRibDao;
    @Autowired
    private BmpGlobalIpRibDao bmpGlobalIpRibDao;
    @Autowired
    private BmpAsnInfoDao bmpAsnInfoDao;
    @Autowired
    private BmpRouteInfoDao bmpRouteInfoDao;
    @Autowired
    private BmpStatsIpOriginsDao bmpStatsIpOriginsDao;
    @Autowired
    private BmpRpkiInfoDao bmpRpkiInfoDao;
    @Autowired
    private SessionUtils sessionUtils;

    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(this::updatePeerStats, 0L, 5L, TimeUnit.MINUTES);
        this.scheduledExecutorService.scheduleAtFixedRate(this::updateStatsByAsn, 0L, 5L, TimeUnit.MINUTES);
        this.scheduledExecutorService.scheduleAtFixedRate(this::updateStatsByPrefix, 0L, 5L, TimeUnit.MINUTES);
        this.scheduledExecutorService.scheduleAtFixedRate(this::updatePeerRibCountStats, 0L, 15L, TimeUnit.MINUTES);
        this.scheduledExecutorService.scheduleAtFixedRate(this::updateGlobalRibsAndAsnInfo, 0L, 60L, TimeUnit.MINUTES);
        this.scheduledExecutorService.scheduleAtFixedRate(this::updateStatsIpOrigins, 0L, 60L, TimeUnit.MINUTES);
    }

    public void destroy() {
        this.scheduledExecutorService.shutdown();
    }

    private void updateGlobalRibsAndAsnInfo() {
        LOG.debug("Updating GlobalRibs ++");
        this.setShouldDeleteForExisting();
        List prefixByASList = this.bmpUnicastPrefixDao.getPrefixesGroupedByAS();
        LOG.debug("Retrieved {} PrefixByAS elements", (Object)prefixByASList.size());
        prefixByASList.forEach(prefixByAS -> {
            BmpGlobalIpRib bmpGlobalIpRib = this.buildGlobalIpRib((PrefixByAS)prefixByAS);
            if (bmpGlobalIpRib != null) {
                try {
                    this.bmpGlobalIpRibDao.saveOrUpdate((Object)bmpGlobalIpRib);
                }
                catch (Exception e) {
                    LOG.error("Exception while persisting BMP global iprib  {}", (Object)bmpGlobalIpRib, (Object)e);
                }
            }
        });
        this.deleteExpiredGlobalRibs();
        LOG.debug("Updating GlobalRibs --");
    }

    private void setShouldDeleteForExisting() {
        List bmpGlobalIpRibs = this.bmpGlobalIpRibDao.findAll();
        bmpGlobalIpRibs.forEach(bmpGlobalIpRib -> {
            bmpGlobalIpRib.setShouldDelete(true);
            this.bmpGlobalIpRibDao.update(bmpGlobalIpRib);
        });
    }

    private void deleteExpiredGlobalRibs() {
        LOG.debug("Deleting expired global ribs ++ ");
        this.bmpGlobalIpRibDao.deleteGlobalRibsBeforeGivenTime(7200L);
        LOG.debug("Deleting expired global ribs -- ");
    }

    private BmpGlobalIpRib buildGlobalIpRib(PrefixByAS prefixByAS) {
        try {
            BmpGlobalIpRib bmpGlobalIpRib = this.bmpGlobalIpRibDao.findByPrefixAndAS(prefixByAS.getPrefix(), prefixByAS.getOriginAs());
            if (bmpGlobalIpRib == null) {
                BmpRpkiInfo bmpRpkiInfo;
                BmpRouteInfo bmpRouteInfo;
                bmpGlobalIpRib = new BmpGlobalIpRib();
                bmpGlobalIpRib.setPrefix(prefixByAS.getPrefix());
                bmpGlobalIpRib.setPrefixLen(prefixByAS.getPrefixLen());
                bmpGlobalIpRib.setTimeStamp(prefixByAS.getTimeStamp());
                bmpGlobalIpRib.setRecvOriginAs(prefixByAS.getOriginAs());
                String prefix = bmpGlobalIpRib.getPrefix();
                if (!Strings.isNullOrEmpty((String)prefix) && (bmpRouteInfo = this.fetchRouteInfo(prefix)) != null) {
                    bmpGlobalIpRib.setIrrOriginAs(bmpRouteInfo.getOriginAs());
                    bmpGlobalIpRib.setIrrSource(bmpRouteInfo.getSource());
                }
                if ((bmpRpkiInfo = this.bmpRpkiInfoDao.findMatchingRpkiInfoForGlobalRIb(prefix, bmpGlobalIpRib.getPrefixLen())) != null) {
                    bmpGlobalIpRib.setRpkiOriginAs(bmpRpkiInfo.getOriginAs());
                }
            }
            bmpGlobalIpRib.setNumPeers(prefixByAS.getCount());
            return bmpGlobalIpRib;
        }
        catch (Exception e) {
            LOG.error("Exception while mapping prefix {} to GlobalIpRib entity", (Object)prefixByAS.getPrefix(), (Object)e);
            return null;
        }
    }

    private BmpRouteInfo fetchRouteInfo(String prefix) {
        List routeInfoList = this.bmpRouteInfoDao.findByPrefix(prefix);
        if (routeInfoList.size() > 0) {
            return (BmpRouteInfo)routeInfoList.get(0);
        }
        return null;
    }

    private void updateStatsIpOrigins() {
        LOG.debug("Updating StatsIpOrigins ++");
        List statsIpOrigins = this.bmpGlobalIpRibDao.getStatsIpOrigins();
        LOG.debug("Retrieved {} StatsIpOrigins elements", (Object)statsIpOrigins.size());
        statsIpOrigins.forEach(stat -> {
            block2: {
                BmpStatsIpOrigins bmpStatsIpOrigins = this.buildBmpStatsOrigins((StatsIpOrigins)stat);
                try {
                    this.bmpStatsIpOriginsDao.saveOrUpdate((Object)bmpStatsIpOrigins);
                }
                catch (Exception e) {
                    BmpStatsIpOrigins retrieved = this.bmpStatsIpOriginsDao.findByAsnAndIntervalTime(bmpStatsIpOrigins.getAsn(), bmpStatsIpOrigins.getTimestamp());
                    if (retrieved == null) break block2;
                    retrieved.setV4prefixes(bmpStatsIpOrigins.getV4prefixes());
                    retrieved.setV6prefixes(bmpStatsIpOrigins.getV6prefixes());
                    retrieved.setV4withrpki(bmpStatsIpOrigins.getV4withrpki());
                    retrieved.setV6withrpki(bmpStatsIpOrigins.getV6withrpki());
                    retrieved.setV4withirr(bmpStatsIpOrigins.getV4withirr());
                    retrieved.setV6withirr(bmpStatsIpOrigins.getV6withirr());
                    this.saveBmpStatsIpOrigin(retrieved);
                }
            }
        });
        LOG.debug("Updating StatsIpOrigins --");
    }

    private void saveBmpStatsIpOrigin(BmpStatsIpOrigins bmpStatsIpOrigins) {
        try {
            this.bmpStatsIpOriginsDao.saveOrUpdate((Object)bmpStatsIpOrigins);
        }
        catch (Exception e) {
            LOG.error("Exception while persisting BMP Stats IpOrigin {}", (Object)bmpStatsIpOrigins, (Object)e);
        }
    }

    private void updatePeerStats() {
        LOG.debug("Updating StatsByPeer ++");
        List statsByPeer = this.bmpIpRibLogDao.getStatsByPeerForInterval("'5 min'");
        LOG.debug("Retrieved {} StatsByPeer elements", (Object)statsByPeer.size());
        statsByPeer.forEach(stat -> {
            block2: {
                BmpStatsByPeer bmpStatsByPeer = this.buildBmpStatsByPeer((StatsByPeer)stat);
                try {
                    this.bmpStatsByPeerDao.saveOrUpdate((Object)bmpStatsByPeer);
                }
                catch (Exception e) {
                    BmpStatsByPeer retrieved = this.bmpStatsByPeerDao.findByPeerAndIntervalTime(bmpStatsByPeer.getPeerHashId(), bmpStatsByPeer.getTimestamp());
                    if (retrieved == null) break block2;
                    retrieved.setUpdates(bmpStatsByPeer.getUpdates());
                    retrieved.setWithdraws(bmpStatsByPeer.getWithdraws());
                    this.saveBmpStatsByPeer(retrieved);
                }
            }
        });
        LOG.debug("Updating StatsByPeer --");
    }

    private void saveBmpStatsByPeer(BmpStatsByPeer bmpStatsByPeer) {
        try {
            this.bmpStatsByPeerDao.saveOrUpdate((Object)bmpStatsByPeer);
        }
        catch (Exception e) {
            LOG.error("Exception while persisting BMP Stats by Peer {}", (Object)bmpStatsByPeer, (Object)e);
        }
    }

    private void updateStatsByAsn() {
        LOG.debug("Updating StatsByAsn ++");
        List statsByAsnList = this.bmpIpRibLogDao.getStatsByAsnForInterval("'5 min'");
        LOG.debug("Retrieved {} StatsByAsn elements", (Object)statsByAsnList.size());
        statsByAsnList.forEach(stat -> {
            block2: {
                BmpStatsByAsn bmpStatsByAsn = this.buildBmpStatsByAsn((StatsByAsn)stat);
                try {
                    this.bmpStatsByAsnDao.saveOrUpdate((Object)bmpStatsByAsn);
                }
                catch (Exception e) {
                    BmpStatsByAsn retrieved = this.bmpStatsByAsnDao.findByAsnAndIntervalTime(bmpStatsByAsn.getPeerHashId(), bmpStatsByAsn.getOriginAsn(), bmpStatsByAsn.getTimestamp());
                    if (retrieved == null) break block2;
                    retrieved.setUpdates(bmpStatsByAsn.getUpdates());
                    retrieved.setWithdraws(bmpStatsByAsn.getWithdraws());
                    this.saveStatsByAsn(retrieved);
                }
            }
        });
        LOG.debug("Updating StatsByAsn --");
    }

    private void saveStatsByAsn(BmpStatsByAsn bmpStatsByAsn) {
        try {
            this.bmpStatsByAsnDao.saveOrUpdate((Object)bmpStatsByAsn);
        }
        catch (Exception e) {
            LOG.error("Exception while persisting BMP Stats by Asn {}", (Object)bmpStatsByAsn, (Object)e);
        }
    }

    private void updateStatsByPrefix() {
        LOG.debug("Updating StatsByPrefix ++");
        List statsByPrefixList = this.bmpIpRibLogDao.getStatsByPrefixForInterval("'5 min'");
        LOG.debug("Retrieved {} StatsByPrefix elements", (Object)statsByPrefixList.size());
        statsByPrefixList.forEach(stat -> {
            block2: {
                BmpStatsByPrefix bmpStatsByPrefix = this.buildBmpStatsByPrefix((StatsByPrefix)stat);
                try {
                    this.bmpStatsByPrefixDao.saveOrUpdate((Object)bmpStatsByPrefix);
                }
                catch (Exception e) {
                    BmpStatsByPrefix retrieved = this.bmpStatsByPrefixDao.findByPrefixAndIntervalTime(bmpStatsByPrefix.getPeerHashId(), bmpStatsByPrefix.getPrefix(), bmpStatsByPrefix.getTimestamp());
                    if (retrieved == null) break block2;
                    retrieved.setUpdates(bmpStatsByPrefix.getUpdates());
                    retrieved.setWithdraws(bmpStatsByPrefix.getWithdraws());
                    this.saveBmpStatsByPrefix(retrieved);
                }
            }
        });
        LOG.debug("Updating StatsByPrefix --");
    }

    private void saveBmpStatsByPrefix(BmpStatsByPrefix bmpStatsByPrefix) {
        try {
            this.bmpStatsByPrefixDao.saveOrUpdate((Object)bmpStatsByPrefix);
        }
        catch (Exception e) {
            LOG.error("Exception while persisting BMP Stats by Prefix {}", (Object)bmpStatsByPrefix, (Object)e);
        }
    }

    private void updatePeerRibCountStats() {
        LOG.debug("Updating StatsPeerRib ++");
        List statsPeerRibs = this.bmpUnicastPrefixDao.getPeerRibCountsByPeer();
        LOG.debug("Retrieved {} StatsPeerRib elements", (Object)statsPeerRibs.size());
        statsPeerRibs.forEach(statsPeerRib -> {
            block2: {
                BmpStatsPeerRib bmpStatsPeerRib = this.buildBmpStatPeerRibCount((StatsPeerRib)statsPeerRib);
                try {
                    this.bmpStatsPeerRibDao.saveOrUpdate((Object)bmpStatsPeerRib);
                }
                catch (Exception e) {
                    BmpStatsPeerRib retrieved = this.bmpStatsPeerRibDao.findByPeerAndIntervalTime(bmpStatsPeerRib.getPeerHashId(), bmpStatsPeerRib.getTimestamp());
                    if (retrieved == null) break block2;
                    retrieved.setV6prefixes(bmpStatsPeerRib.getV6prefixes());
                    retrieved.setV4prefixes(bmpStatsPeerRib.getV4prefixes());
                    this.saveStatsPeerRib(retrieved);
                }
            }
        });
        LOG.debug("Updating StatsPeerRib --");
    }

    private void saveStatsPeerRib(BmpStatsPeerRib bmpStatsPeerRib) {
        try {
            this.bmpStatsPeerRibDao.saveOrUpdate((Object)bmpStatsPeerRib);
        }
        catch (Exception e) {
            LOG.error("Exception while persisting BMP Stats Peer Rib {}", (Object)bmpStatsPeerRib, (Object)e);
        }
    }

    private BmpStatsPeerRib buildBmpStatPeerRibCount(StatsPeerRib statsPeerRib) {
        BmpStatsPeerRib bmpStatsPeerRib = new BmpStatsPeerRib();
        bmpStatsPeerRib.setPeerHashId(statsPeerRib.getPeerHashId());
        bmpStatsPeerRib.setTimestamp(statsPeerRib.getIntervalTime());
        bmpStatsPeerRib.setV4prefixes(statsPeerRib.getV4prefixes());
        bmpStatsPeerRib.setV6prefixes(statsPeerRib.getV6prefixes());
        return bmpStatsPeerRib;
    }

    private BmpStatsByPeer buildBmpStatsByPeer(StatsByPeer statsByPeer) {
        BmpStatsByPeer bmpStatsByPeer = new BmpStatsByPeer();
        bmpStatsByPeer.setPeerHashId(statsByPeer.getPeerHashId());
        bmpStatsByPeer.setTimestamp(statsByPeer.getIntervalTime());
        bmpStatsByPeer.setUpdates(statsByPeer.getUpdates());
        bmpStatsByPeer.setWithdraws(statsByPeer.getWithdraws());
        return bmpStatsByPeer;
    }

    private BmpStatsByAsn buildBmpStatsByAsn(StatsByAsn statsByAsn) {
        BmpStatsByAsn bmpStatsByAsn = new BmpStatsByAsn();
        bmpStatsByAsn.setPeerHashId(statsByAsn.getPeerHashId());
        bmpStatsByAsn.setOriginAsn(statsByAsn.getOriginAs());
        bmpStatsByAsn.setTimestamp(statsByAsn.getIntervalTime());
        bmpStatsByAsn.setUpdates(statsByAsn.getUpdates());
        bmpStatsByAsn.setWithdraws(statsByAsn.getWithdraws());
        return bmpStatsByAsn;
    }

    private BmpStatsByPrefix buildBmpStatsByPrefix(StatsByPrefix statsByPrefix) {
        BmpStatsByPrefix bmpStatsByPrefix = new BmpStatsByPrefix();
        bmpStatsByPrefix.setPeerHashId(statsByPrefix.getPeerHashId());
        bmpStatsByPrefix.setPrefix(statsByPrefix.getPrefix());
        bmpStatsByPrefix.setPrefixLen(statsByPrefix.getPrefixLen());
        bmpStatsByPrefix.setTimestamp(statsByPrefix.getIntervalTime());
        bmpStatsByPrefix.setUpdates(statsByPrefix.getUpdates());
        bmpStatsByPrefix.setWithdraws(statsByPrefix.getWithdraws());
        return bmpStatsByPrefix;
    }

    private BmpStatsIpOrigins buildBmpStatsOrigins(StatsIpOrigins statsIpOrigins) {
        BmpStatsIpOrigins bmpStatsIpOrigins = new BmpStatsIpOrigins();
        bmpStatsIpOrigins.setAsn(statsIpOrigins.getRecvOriginAs());
        bmpStatsIpOrigins.setTimestamp(statsIpOrigins.getIntervalTime());
        bmpStatsIpOrigins.setV4prefixes(statsIpOrigins.getV4prefixes());
        bmpStatsIpOrigins.setV6prefixes(statsIpOrigins.getV6prefixes());
        bmpStatsIpOrigins.setV4withrpki(statsIpOrigins.getV4withrpki());
        bmpStatsIpOrigins.setV6withrpki(statsIpOrigins.getV6withrpki());
        bmpStatsIpOrigins.setV4withirr(statsIpOrigins.getV4withirr());
        bmpStatsIpOrigins.setV6withirr(statsIpOrigins.getV6withirr());
        return bmpStatsIpOrigins;
    }

    public void setBmpIpRibLogDao(BmpIpRibLogDao bmpIpRibLogDao) {
        this.bmpIpRibLogDao = bmpIpRibLogDao;
    }

    public void setBmpStatsByPeerDao(BmpStatsByPeerDao bmpStatsByPeerDao) {
        this.bmpStatsByPeerDao = bmpStatsByPeerDao;
    }

    public void setBmpStatsByAsnDao(BmpStatsByAsnDao bmpStatsByAsnDao) {
        this.bmpStatsByAsnDao = bmpStatsByAsnDao;
    }

    public void setBmpStatsByPrefixDao(BmpStatsByPrefixDao bmpStatsByPrefixDao) {
        this.bmpStatsByPrefixDao = bmpStatsByPrefixDao;
    }

    public void setBmpUnicastPrefixDao(BmpUnicastPrefixDao bmpUnicastPrefixDao) {
        this.bmpUnicastPrefixDao = bmpUnicastPrefixDao;
    }

    public void setBmpStatsPeerRibDao(BmpStatsPeerRibDao bmpStatsPeerRibDao) {
        this.bmpStatsPeerRibDao = bmpStatsPeerRibDao;
    }

    public void setBmpGlobalIpRibDao(BmpGlobalIpRibDao bmpGlobalIpRibDao) {
        this.bmpGlobalIpRibDao = bmpGlobalIpRibDao;
    }

    public void setBmpAsnInfoDao(BmpAsnInfoDao bmpAsnInfoDao) {
        this.bmpAsnInfoDao = bmpAsnInfoDao;
    }

    public void setBmpRouteInfoDao(BmpRouteInfoDao bmpRouteInfoDao) {
        this.bmpRouteInfoDao = bmpRouteInfoDao;
    }

    public void setBmpStatsIpOriginsDao(BmpStatsIpOriginsDao bmpStatsIpOriginsDao) {
        this.bmpStatsIpOriginsDao = bmpStatsIpOriginsDao;
    }

    public void setBmpRpkiInfoDao(BmpRpkiInfoDao bmpRpkiInfoDao) {
        this.bmpRpkiInfoDao = bmpRpkiInfoDao;
    }

    public void setSessionUtils(SessionUtils sessionUtils) {
        this.sessionUtils = sessionUtils;
    }
}

