/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.init;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ScriptException;

public class CompositeDatabasePopulator
implements DatabasePopulator {
    private final List<DatabasePopulator> populators = new ArrayList<DatabasePopulator>(4);

    public void setPopulators(DatabasePopulator ... populators) {
        this.populators.clear();
        this.populators.addAll(Arrays.asList(populators));
    }

    public void addPopulators(DatabasePopulator ... populators) {
        this.populators.addAll(Arrays.asList(populators));
    }

    @Override
    public void populate(Connection connection) throws SQLException, ScriptException {
        for (DatabasePopulator populator : this.populators) {
            populator.populate(connection);
        }
    }
}

