/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.sampleread.aggregation;

import com.google.common.base.Optional;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.timeseries.DataPoint;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.Tag;
import org.opennms.integration.api.v1.timeseries.TimeSeriesData;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableDataPoint;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Counter;
import org.opennms.newts.api.Element;
import org.opennms.newts.api.Gauge;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;

public class NewtsConverterUtils {
    public static Iterator<Results.Row<Sample>> samplesToNewtsRowIterator(TimeSeriesData allDataPoints) {
        return allDataPoints.getDataPoints().stream().map(d -> NewtsConverterUtils.dataPointToRow(allDataPoints.getMetric(), d)).collect(Collectors.toList()).iterator();
    }

    private static Results.Row<Sample> dataPointToRow(Metric metric, DataPoint dataPoint) {
        Optional resourceAttributes = metric.getExternalTags().isEmpty() ? Optional.absent() : Optional.of(NewtsConverterUtils.asMap(metric.getMetaTags()));
        Timestamp timestamp = Timestamp.fromEpochMillis((long)dataPoint.getTime().toEpochMilli());
        Context context = new Context("not relevant");
        Resource resource = new Resource(metric.getFirstTagByKey("resourceId").getValue(), resourceAttributes);
        String name = metric.getFirstTagByKey("name").getValue();
        MetricType type = NewtsConverterUtils.toNewts(Metric.Mtype.valueOf((String)metric.getFirstTagByKey("mtype").getValue()));
        ValueType<?> value = NewtsConverterUtils.toNewtsValue(metric, dataPoint);
        HashMap attributes = new HashMap();
        Sample newtsSample = new Sample(timestamp, context, resource, name, type, value, attributes);
        Results.Row row = new Results.Row(timestamp, resource);
        row.addElement((Element)newtsSample);
        return row;
    }

    private static MetricType toNewts(Metric.Mtype type) {
        if (Metric.Mtype.count == type) {
            return MetricType.COUNTER;
        }
        if (Metric.Mtype.gauge == type) {
            return MetricType.GAUGE;
        }
        throw new IllegalArgumentException(String.format("I don't know how to map %s to MetricType", type));
    }

    private static ValueType<?> toNewtsValue(Metric metric, DataPoint dataPoint) {
        Metric.Mtype mtype = Metric.Mtype.valueOf((String)metric.getFirstTagByKey("mtype").getValue());
        if (Metric.Mtype.count == mtype) {
            return new Counter(dataPoint.getValue().longValue());
        }
        if (Metric.Mtype.gauge == mtype) {
            return new Gauge(dataPoint.getValue().doubleValue());
        }
        throw new IllegalArgumentException(String.format("I don't know how to map %s to ValueType", mtype));
    }

    public static DataPoint toTimeSeriesDataPoint(Results.Row<Measurement> row) {
        int sizeOfRow = row.getElements().size();
        if (row.getElements().size() != 1) {
            throw new IllegalArgumentException(String.format("expected exactly one column in row but was %s", sizeOfRow));
        }
        Measurement measurement = (Measurement)row.getElements().iterator().next();
        return ImmutableDataPoint.builder().time(NewtsConverterUtils.toInstant(measurement.getTimestamp())).value(measurement.getValue()).build();
    }

    public static Instant toInstant(Timestamp timestamp) {
        return Instant.ofEpochMilli(timestamp.asMillis());
    }

    public static Map<String, String> asMap(Collection<Tag> tags) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Tag tag : tags) {
            map.put(tag.getKey(), tag.getValue());
        }
        return map;
    }
}

