/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.alarms.history.elastic.mapping;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.mapstruct.factory.Mappers;
import org.opennms.core.cache.Cache;
import org.opennms.features.alarms.history.elastic.dto.AlarmDocumentDTO;
import org.opennms.features.alarms.history.elastic.dto.AlarmDocumentFactory;
import org.opennms.features.alarms.history.elastic.dto.NodeDocumentDTO;
import org.opennms.features.alarms.history.elastic.mapping.AlarmMapper;
import org.opennms.netmgt.model.OnmsAlarm;

public class MapStructDocumentImpl
implements Function<OnmsAlarm, AlarmDocumentDTO>,
AlarmDocumentFactory,
AlarmMapper.MappingContext {
    private static final AlarmMapper alarmMapper = (AlarmMapper)Mappers.getMapper(AlarmMapper.class);
    private final Cache<Integer, Optional<NodeDocumentDTO>> nodeInfoCache;
    private final LongSupplier currentTime;

    public MapStructDocumentImpl(Cache<Integer, Optional<NodeDocumentDTO>> nodeInfoCache, LongSupplier currentTime) {
        this.nodeInfoCache = nodeInfoCache;
        this.currentTime = currentTime;
    }

    @Override
    public AlarmDocumentDTO apply(OnmsAlarm alarm) {
        return alarmMapper.map(alarm, this);
    }

    @Override
    public AlarmDocumentDTO createAlarmDocumentForDelete(int alarmId, String reductionKey) {
        AlarmDocumentDTO doc = new AlarmDocumentDTO();
        doc.setId(alarmId);
        doc.setReductionKey(reductionKey);
        long now = this.getCurrentTime();
        doc.setUpdateTime(now);
        doc.setDeletedTime(now);
        return doc;
    }

    @Override
    public Cache<Integer, Optional<NodeDocumentDTO>> getNodeInfoCache() {
        return this.nodeInfoCache;
    }

    @Override
    public long getCurrentTime() {
        return this.currentTime.getAsLong();
    }
}

