/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.alarms.history.elastic;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.opennms.core.health.api.Context;
import org.opennms.core.health.api.HealthCheck;
import org.opennms.core.health.api.Response;
import org.opennms.core.health.api.Status;
import org.opennms.features.alarms.history.elastic.ElasticAlarmHistoryRepository;

public class ElasticHealthCheck
implements HealthCheck {
    private final ElasticAlarmHistoryRepository elasticAlarmHistoryRepository;

    public ElasticHealthCheck(ElasticAlarmHistoryRepository elasticAlarmHistoryRepository) {
        this.elasticAlarmHistoryRepository = Objects.requireNonNull(elasticAlarmHistoryRepository);
    }

    public String getDescription() {
        return "Number of active alarms stored in Elasticsearch (Alarm History)";
    }

    public List<String> getTags() {
        return Arrays.asList("elastic");
    }

    public Response perform(Context context) {
        long numAlarms = this.elasticAlarmHistoryRepository.getNumActiveAlarmsNow();
        return new Response(Status.Success, String.format("Found %d alarms.", numAlarms));
    }
}

