/*
 * Decompiled with CFR 0.152.
 */
package rpc.security.ntlm;

import java.io.IOException;
import java.util.Properties;
import rpc.BindException;
import rpc.Connection;
import rpc.ConnectionContext;
import rpc.ConnectionOrientedPdu;
import rpc.FaultException;
import rpc.PresentationException;
import rpc.RpcException;
import rpc.core.PresentationContext;
import rpc.core.PresentationResult;
import rpc.pdu.AlterContextPdu;
import rpc.pdu.AlterContextResponsePdu;
import rpc.pdu.Auth3Pdu;
import rpc.pdu.BindAcknowledgePdu;
import rpc.pdu.BindNoAcknowledgePdu;
import rpc.pdu.BindPdu;
import rpc.pdu.FaultCoPdu;
import rpc.security.ntlm.NtlmConnection;

public class NtlmConnectionContext
implements ConnectionContext {
    private int maxTransmitFragment = 4280;
    private int maxReceiveFragment = 4280;
    private NtlmConnection connection;
    private boolean established;
    private int transmitLength;
    private int receiveLength;
    private int assocGroupId = 0;

    public ConnectionOrientedPdu init2(PresentationContext context, Properties properties) {
        this.established = false;
        if (properties != null) {
            String maxReceive;
            String maxTransmit = properties.getProperty("rpc.connectionContext.maxTransmitFragment");
            if (maxTransmit != null) {
                this.maxTransmitFragment = Integer.parseInt(maxTransmit);
            }
            if ((maxReceive = properties.getProperty("rpc.connectionContext.maxReceiveFragment")) != null) {
                this.maxReceiveFragment = Integer.parseInt(maxReceive);
            }
        }
        BindPdu pdu = new BindPdu();
        pdu.setContextList(new PresentationContext[]{context});
        pdu.setMaxTransmitFragment(this.maxTransmitFragment);
        pdu.setMaxReceiveFragment(this.maxReceiveFragment);
        this.connection = new NtlmConnection(properties);
        this.assocGroupId = 0;
        return pdu;
    }

    @Override
    public ConnectionOrientedPdu init(PresentationContext context, Properties properties) throws IOException {
        BindPdu pdu = (BindPdu)this.init2(context, properties);
        pdu.resetCallIdCounter();
        return pdu;
    }

    @Override
    public ConnectionOrientedPdu alter(PresentationContext context) {
        this.established = false;
        AlterContextPdu pdu = new AlterContextPdu();
        pdu.setContextList(new PresentationContext[]{context});
        pdu.setAssociationGroupId(this.assocGroupId);
        return pdu;
    }

    @Override
    public ConnectionOrientedPdu accept(ConnectionOrientedPdu pdu) throws IOException {
        switch (pdu.getType()) {
            case 12: {
                BindAcknowledgePdu bindAck = (BindAcknowledgePdu)pdu;
                PresentationResult[] results = bindAck.getResultList();
                if (results == null) {
                    throw new BindException("No presentation context results.");
                }
                for (int i = results.length - 1; i >= 0; --i) {
                    if (results[i].result == 0) continue;
                    throw new PresentationException("Context rejected.", results[i]);
                }
                this.transmitLength = bindAck.getMaxReceiveFragment();
                this.receiveLength = bindAck.getMaxTransmitFragment();
                this.established = true;
                this.connection.setTransmitLength(this.transmitLength);
                this.connection.setReceiveLength(this.receiveLength);
                this.assocGroupId = bindAck.getAssociationGroupId();
                return new Auth3Pdu();
            }
            case 15: {
                AlterContextResponsePdu alterContextResponse = (AlterContextResponsePdu)pdu;
                PresentationResult[] results = alterContextResponse.getResultList();
                if (results == null) {
                    throw new BindException("No presentation context results.");
                }
                for (int i = results.length - 1; i >= 0; --i) {
                    if (results[i].result == 0) continue;
                    throw new PresentationException("Context rejected.", results[i]);
                }
                this.established = true;
                return null;
            }
            case 13: {
                throw new BindException("Unable to bind.", ((BindNoAcknowledgePdu)pdu).getRejectReason());
            }
            case 3: {
                throw new FaultException("Fault occurred.", ((FaultCoPdu)pdu).getStatus());
            }
            case 17: {
                throw new RpcException("Server shutdown connection.");
            }
            case 11: {
                this.established = false;
                throw new RuntimeException();
            }
            case 14: {
                this.established = false;
                throw new RuntimeException();
            }
            case 16: {
                this.established = true;
                return null;
            }
        }
        throw new RpcException("Unknown/unacceptable PDU type.");
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isEstablished() {
        return this.established;
    }
}

