/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.dao;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.soa.lookup.ServiceLookup;
import org.opennms.core.soa.lookup.ServiceLookupBuilder;
import org.opennms.core.soa.lookup.ServiceRegistryLookup;
import org.opennms.core.soa.support.DefaultServiceRegistry;
import org.opennms.features.apilayer.utils.ModelMappers;
import org.opennms.features.situationfeedback.api.FeedbackException;
import org.opennms.features.situationfeedback.api.FeedbackRepository;
import org.opennms.integration.api.v1.dao.AlarmFeedbackDao;
import org.opennms.integration.api.v1.model.AlarmFeedback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmFeedbackDaoImpl
implements AlarmFeedbackDao {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmFeedbackDaoImpl.class);
    private final ServiceLookup<Class<?>, String> SERVICE_LOOKUP;

    public AlarmFeedbackDaoImpl(long gracePeriodInMs, long sleepTimeInMs, long waitTimeMs) {
        this.SERVICE_LOOKUP = new ServiceLookupBuilder((ServiceLookup)new ServiceRegistryLookup((ServiceRegistry)DefaultServiceRegistry.INSTANCE)).blocking(gracePeriodInMs, sleepTimeInMs, waitTimeMs).build();
    }

    private FeedbackRepository getRepository() {
        return (FeedbackRepository)this.SERVICE_LOOKUP.lookup(FeedbackRepository.class, null);
    }

    public List<AlarmFeedback> getFeedback() {
        FeedbackRepository feedbackRepository = this.getRepository();
        if (feedbackRepository == null) {
            return Collections.emptyList();
        }
        try {
            return feedbackRepository.getAllFeedback().stream().map(ModelMappers::toFeedback).collect(Collectors.toList());
        }
        catch (FeedbackException e) {
            throw new RuntimeException(e);
        }
    }

    public void submitFeedback(List<AlarmFeedback> alarmFeedback) {
        FeedbackRepository feedbackRepository = this.getRepository();
        if (feedbackRepository == null) {
            throw new RuntimeException("Could not find a feedback repository");
        }
        List mappedFeedback = alarmFeedback.stream().map(ModelMappers::fromFeedback).collect(Collectors.toList());
        try {
            feedbackRepository.persist(mappedFeedback);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute query: " + e.getMessage(), e);
        }
    }
}

