/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.dao;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.features.apilayer.utils.ModelMappers;
import org.opennms.integration.api.v1.graph.NodeRef;
import org.opennms.integration.api.v1.model.Alarm;
import org.opennms.integration.api.v1.model.Severity;
import org.opennms.integration.api.v1.ticketing.Ticket;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.AlarmEntityNotifier;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.AckType;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.TroubleTicketState;

public class AlarmDaoImpl
implements org.opennms.integration.api.v1.dao.AlarmDao {
    private final AlarmDao alarmDao;
    private final AcknowledgmentDao ackDao;
    private final AlarmEntityNotifier alarmEntityNotifier;
    private final SessionUtils sessionUtils;

    public AlarmDaoImpl(AlarmDao alarmDao, AcknowledgmentDao ackDao, AlarmEntityNotifier alarmEntityNotifier, SessionUtils sessionUtils) {
        this.alarmDao = Objects.requireNonNull(alarmDao);
        this.alarmEntityNotifier = Objects.requireNonNull(alarmEntityNotifier);
        this.ackDao = Objects.requireNonNull(ackDao);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
    }

    public Long getAlarmCount() {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsAlarm.class);
        return (Long)this.sessionUtils.withReadOnlyTransaction(() -> this.alarmDao.countMatching(criteriaBuilder.toCriteria()));
    }

    public List<Alarm> getAlarms() {
        return (List)this.sessionUtils.withReadOnlyTransaction(() -> this.alarmDao.findAll().stream().map(ModelMappers::toAlarm).collect(Collectors.toList()));
    }

    public Optional<Alarm> getAlarmWithHighestSeverity(NodeRef nodeRef) {
        Criteria criteria = new CriteriaBuilder(OnmsAlarm.class).alias("node", "node").orderBy("severity", false).and(new Restriction[]{Restrictions.eq((String)"node.foreignSource", (Object)nodeRef.getForeignSource()), Restrictions.eq((String)"node.foreignId", (Object)nodeRef.getForeignId())}).limit(Integer.valueOf(1)).toCriteria();
        return (Optional)this.sessionUtils.withReadOnlyTransaction(() -> {
            List matching = this.alarmDao.findMatching(criteria);
            if (matching.isEmpty()) {
                return Optional.empty();
            }
            Alarm alarm = ModelMappers.toAlarm((OnmsAlarm)matching.get(0));
            return Optional.of(alarm);
        });
    }

    public Optional<Alarm> getAlarmForTicket(String ticketId) {
        Criteria criteria = new CriteriaBuilder(OnmsAlarm.class).and(new Restriction[]{Restrictions.eq((String)"tticketId", (Object)ticketId)}).limit(Integer.valueOf(1)).toCriteria();
        return (Optional)this.sessionUtils.withReadOnlyTransaction(() -> {
            List matching = this.alarmDao.findMatching(criteria);
            if (matching.isEmpty()) {
                return Optional.empty();
            }
            Alarm alarm = ModelMappers.toAlarm((OnmsAlarm)matching.get(0));
            return Optional.of(alarm);
        });
    }

    public void setTicketState(Ticket.State state, int ... alarmIds) {
        this.sessionUtils.withTransaction(() -> Arrays.stream(alarmIds).boxed().map(arg_0 -> ((AlarmDao)this.alarmDao).get(arg_0)).forEach(alarm -> {
            TroubleTicketState previousState = alarm.getTTicketState();
            alarm.setTTicketState(ModelMappers.fromTicketState(state));
            this.alarmDao.saveOrUpdate(alarm);
            this.alarmEntityNotifier.didChangeTicketStateForAlarm(alarm, previousState);
        }));
    }

    public void acknowledge(String user, int ... alarmIds) {
        this.sessionUtils.withTransaction(() -> {
            List acks = Arrays.stream(alarmIds).boxed().map(id -> {
                OnmsAcknowledgment ack = new OnmsAcknowledgment(user);
                ack.setAckType(AckType.ALARM);
                ack.setAckAction(AckAction.ACKNOWLEDGE);
                ack.setRefId(id);
                return ack;
            }).collect(Collectors.toUnmodifiableList());
            this.ackDao.processAcks(acks);
        });
    }

    public void unacknowledge(int ... alarmIds) {
        this.sessionUtils.withTransaction(() -> {
            List acks = Arrays.stream(alarmIds).boxed().map(id -> {
                OnmsAcknowledgment ack = new OnmsAcknowledgment();
                ack.setAckType(AckType.ALARM);
                ack.setAckAction(AckAction.UNACKNOWLEDGE);
                ack.setRefId(id);
                return ack;
            }).collect(Collectors.toUnmodifiableList());
            this.ackDao.processAcks(acks);
        });
    }

    public void escalate(String user, int ... alarmIds) {
        this.sessionUtils.withTransaction(() -> {
            List acks = Arrays.stream(alarmIds).boxed().map(id -> {
                OnmsAcknowledgment ack = new OnmsAcknowledgment(user);
                ack.setAckType(AckType.ALARM);
                ack.setAckAction(AckAction.ESCALATE);
                ack.setRefId(id);
                return ack;
            }).collect(Collectors.toUnmodifiableList());
            this.ackDao.processAcks(acks);
        });
    }

    public void clear(int ... alarmIds) {
        this.sessionUtils.withTransaction(() -> {
            List acks = Arrays.stream(alarmIds).boxed().map(id -> {
                OnmsAcknowledgment ack = new OnmsAcknowledgment();
                ack.setAckType(AckType.ALARM);
                ack.setAckAction(AckAction.CLEAR);
                ack.setRefId(id);
                return ack;
            }).collect(Collectors.toUnmodifiableList());
            this.ackDao.processAcks(acks);
        });
    }

    public void setSeverity(Severity severity, int ... alarmIds) {
        OnmsSeverity onmsSeverity = ModelMappers.fromSeverity(severity);
        this.sessionUtils.withTransaction(() -> {
            Criteria criteria = new CriteriaBuilder(OnmsAlarm.class).and(new Restriction[]{Restrictions.in((String)"id", Arrays.asList(new int[][]{alarmIds}))}).toCriteria();
            List alarms = this.alarmDao.findMatching(criteria);
            alarms.forEach(alarm -> {
                OnmsSeverity previousSeverity = alarm.getSeverity();
                alarm.setSeverity(onmsSeverity);
                this.alarmDao.saveOrUpdate(alarm);
                this.alarmEntityNotifier.didUpdateAlarmSeverity(alarm, previousSeverity);
            });
        });
    }
}

