/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.install;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPv6Validator {
    private static final String REGISTRY_CURRENTVERSION = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion";
    Pattern SERVICE_PACK_PATTERN = Pattern.compile("Service Pack (\\d+)");

    public boolean isPlatformIPv6Ready() {
        boolean ok = true;
        if (Platform.isWindows()) {
            IPv6Validator.debug(null, "Looks like we're on Windows...  Validating.", new Object[0]);
            String architecture = System.getenv("PROCESSOR_ARCHITECTURE");
            String rawVersion = this.getStringFromRegistry("CurrentVersion");
            if (rawVersion == null) {
                IPv6Validator.error(null, "Unable to determine Windows version from the registry.", new Object[0]);
                return false;
            }
            Float version = Float.valueOf(rawVersion);
            if (version.floatValue() < 5.1f) {
                IPv6Validator.error(null, "You must be running at least Windows Vista (32-bit) or Windows XP Professional Service Pack 2 (64-bit), but Windows kernel version is only %.1f!", version);
                return false;
            }
            String rawBuild = this.getStringFromRegistry("CurrentBuildNumber");
            Integer build = 0;
            if (rawBuild != null) {
                build = Integer.valueOf(rawBuild);
            }
            String csdVersion = this.getStringFromRegistry("CSDVersion");
            Integer servicePack = 0;
            if (csdVersion != null) {
                Matcher m = this.SERVICE_PACK_PATTERN.matcher(csdVersion);
                if (m.matches()) {
                    servicePack = Integer.valueOf(m.group(1));
                }
                if (servicePack > 0) {
                    IPv6Validator.debug(null, "Found Service Pack " + servicePack, new Object[0]);
                }
            }
            if (version.floatValue() < 6.0f) {
                String productName = this.getStringFromRegistry("ProductName");
                if (architecture.equals("x86") && (productName == null || !productName.contains("Server 2003"))) {
                    IPv6Validator.error(null, "OpenNMS does not support 32-bit Windows XP.", new Object[0]);
                    ok = false;
                }
                if (servicePack < 2) {
                    IPv6Validator.error(null, "OpenNMS requires Service Pack 2 or higher on Windows XP and Windows Server 2003.", new Object[0]);
                    ok = false;
                }
                if (ok) {
                    for (String hotfix : new String[]{"978338", "947369"}) {
                        if (this.checkHotfix(hotfix, "Windows XP or Windows Server 2003")) continue;
                        IPv6Validator.warn(null, "Hotfix %s was not found.", hotfix);
                        IPv6Validator.warn(null, "Go to http://support.microsoft.com/kb/%s and install it", hotfix);
                        ok = false;
                    }
                    if (!ok) {
                        IPv6Validator.error(null, "One or more HotFixes was not found.  Please install them and try again.", new Object[0]);
                        return false;
                    }
                }
            }
            if (version.floatValue() < 6.1f && servicePack < 1) {
                IPv6Validator.error(null, "OpenNMS requires Service Pack 1 or higher on Windows Vista and Windows Server 2008.", new Object[0]);
                ok = false;
            }
            IPv6Validator.debug(null, "Windows NT Version %.1f, Build %d (Service Pack %d)", version, build, servicePack);
        }
        IPv6Validator.debug(null, "Platform is IPv6 ready: %s", ok);
        return ok;
    }

    private boolean checkHotfix(String hotfix, String os) {
        if (!this.keyExists(WinReg.HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Hotfix\\KB" + hotfix)) {
            IPv6Validator.error(null, "OpenNMS requires HotFix KB" + hotfix + " to be installed for IPv6 to function properly on " + os + ".  To install it, see the following link: http://support.microsoft.com/?kbid=" + hotfix, new Object[0]);
            return false;
        }
        IPv6Validator.debug(null, "Found HotFix KB" + hotfix, new Object[0]);
        return true;
    }

    private static void error(Throwable t, String format, Object ... args) {
        System.err.println(String.format("ERROR: " + format, args));
        if (t != null) {
            t.printStackTrace();
        }
    }

    private static void warn(Throwable t, String format, Object ... args) {
        System.err.println(String.format("WARNING: " + format, args));
        if (t != null) {
            t.printStackTrace();
        }
    }

    private static void debug(Throwable t, String format, Object ... args) {
        System.err.println(String.format("DEBUG: " + format, args));
        if (t != null) {
            t.printStackTrace();
        }
    }

    private String getStringFromRegistry(String key) {
        try {
            return Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)REGISTRY_CURRENTVERSION, (String)key);
        }
        catch (Throwable t) {
            IPv6Validator.warn(null, "Unable to retrieve the value for %s\\%s", REGISTRY_CURRENTVERSION, key);
            return null;
        }
    }

    public boolean keyExists(WinReg.HKEY root, String key) {
        return Advapi32Util.registryKeyExists((WinReg.HKEY)root, (String)key);
    }

    public static void main(String ... args) throws IOException {
        IPv6Validator checker = new IPv6Validator();
        IPv6Validator.debug(null, "ready = " + checker.isPlatformIPv6Ready(), new Object[0]);
    }
}

