/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.net.InetAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsIpInterfaceList;
import org.opennms.netmgt.model.OnmsMetaData;
import org.opennms.netmgt.model.OnmsMetaDataList;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.api.RestUtils;
import org.opennms.web.rest.support.Aliases;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.support.RedirectHelper;
import org.opennms.web.rest.support.SearchProperties;
import org.opennms.web.rest.support.SearchProperty;
import org.opennms.web.rest.v2.AbstractNodeDependentRestService;
import org.opennms.web.rest.v2.NodeMonitoredServiceRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class NodeIpInterfacesRestService
extends AbstractNodeDependentRestService<OnmsIpInterface, OnmsIpInterface, Integer, String> {
    @Autowired
    private IpInterfaceDao m_dao;

    protected IpInterfaceDao getDao() {
        return this.m_dao;
    }

    @Override
    protected Class<OnmsIpInterface> getDaoClass() {
        return OnmsIpInterface.class;
    }

    @Override
    protected Class<OnmsIpInterface> getQueryBeanClass() {
        return OnmsIpInterface.class;
    }

    @Override
    protected Set<SearchProperty> getQueryProperties() {
        return SearchProperties.IP_INTERFACE_SERVICE_PROPERTIES;
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder(UriInfo uriInfo) {
        CriteriaBuilder builder = new CriteriaBuilder(this.getDaoClass());
        builder.alias("snmpInterface", Aliases.snmpInterface.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("monitoredServices", Aliases.monitoredService.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("monitoredService.serviceType", Aliases.serviceType.toString(), Alias.JoinType.LEFT_JOIN);
        builder.distinct();
        this.updateCriteria(uriInfo, builder);
        return builder;
    }

    @Override
    protected JaxbListWrapper<OnmsIpInterface> createListWrapper(Collection<OnmsIpInterface> list) {
        return new OnmsIpInterfaceList(list);
    }

    @Override
    protected Response doCreate(SecurityContext securityContext, UriInfo uriInfo, OnmsIpInterface ipInterface) {
        OnmsNode node = this.getNode(uriInfo);
        if (node == null) {
            throw NodeIpInterfacesRestService.getException(Response.Status.BAD_REQUEST, "Node was not found.", new String[0]);
        }
        if (ipInterface == null) {
            throw NodeIpInterfacesRestService.getException(Response.Status.BAD_REQUEST, "IP Interface object cannot be null", new String[0]);
        }
        if (ipInterface.getIpAddress() == null) {
            throw NodeIpInterfacesRestService.getException(Response.Status.BAD_REQUEST, "IP Interface's ipAddress cannot be null", new String[0]);
        }
        if (ipInterface.getIpAddress().getAddress() == null) {
            throw NodeIpInterfacesRestService.getException(Response.Status.BAD_REQUEST, "IP Interface's ipAddress bytes cannot be null", new String[0]);
        }
        node.addIpInterface(ipInterface);
        this.getDao().save((Object)ipInterface);
        Event event = EventUtils.createNodeGainedInterfaceEvent((String)"ReST", (int)node.getId(), (InetAddress)ipInterface.getIpAddress());
        this.sendEvent(event);
        return Response.created((URI)RedirectHelper.getRedirectUri(uriInfo, ipInterface.getIpAddress().getHostAddress())).build();
    }

    @Override
    protected Response doUpdateProperties(SecurityContext securityContext, UriInfo uriInfo, OnmsIpInterface targetObject, MultivaluedMapImpl params) {
        if (params.getFirst("ipAddress") != null) {
            throw NodeIpInterfacesRestService.getException(Response.Status.BAD_REQUEST, "Cannot change the IP address.", new String[0]);
        }
        RestUtils.setBeanProperties((Object)targetObject, (MultivaluedMap)params);
        this.getDao().update((Object)targetObject);
        return Response.noContent().build();
    }

    @Override
    protected void doDelete(SecurityContext securityContext, UriInfo uriInfo, OnmsIpInterface intf) {
        intf.getNode().getIpInterfaces().remove(intf);
        this.getDao().delete((Object)intf);
        Event e = EventUtils.createDeleteInterfaceEvent((String)"ReST", (long)intf.getNodeId().intValue(), (String)intf.getIpAddress().getHostAddress(), (int)-1, (long)-1L);
        this.sendEvent(e);
    }

    @Override
    protected OnmsIpInterface doGet(UriInfo uriInfo, String ipAddress) {
        OnmsIpInterface iface;
        OnmsNode node = this.getNode(uriInfo);
        OnmsIpInterface onmsIpInterface = iface = node == null ? null : node.getIpInterfaceByIpAddress(ipAddress);
        if (iface != null) {
            this.getDao().initialize((Object)iface.getSnmpInterface());
        }
        return iface;
    }

    @Path(value="{id}/services")
    public NodeMonitoredServiceRestService getMonitoredServicesResource(@Context ResourceContext context) {
        return (NodeMonitoredServiceRestService)context.getResource(NodeMonitoredServiceRestService.class);
    }

    protected OnmsIpInterface getInterface(UriInfo uriInfo, String ipAddress) {
        OnmsNode node = this.getNode(uriInfo);
        return node.getIpInterfaceByIpAddress(ipAddress);
    }

    @GET
    @Path(value="{ipAddress}/metadata")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public OnmsMetaDataList getMetaData(@Context UriInfo uriInfo, @PathParam(value="ipAddress") String ipAddress) {
        OnmsIpInterface intf = this.getInterface(uriInfo, ipAddress);
        if (intf == null) {
            throw NodeIpInterfacesRestService.getException(Response.Status.BAD_REQUEST, "getMetaData: Can't find interface " + ipAddress, new String[0]);
        }
        return new OnmsMetaDataList((Collection)intf.getMetaData());
    }

    @GET
    @Path(value="{ipAddress}/metadata/{context}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public OnmsMetaDataList getMetaData(@Context UriInfo uriInfo, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="context") String context) {
        OnmsIpInterface intf = this.getInterface(uriInfo, ipAddress);
        if (intf == null) {
            throw NodeIpInterfacesRestService.getException(Response.Status.BAD_REQUEST, "getMetaData: Can't find interface " + ipAddress, new String[0]);
        }
        return new OnmsMetaDataList((Collection)intf.getMetaData().stream().filter(e -> context.equals(e.getContext())).collect(Collectors.toList()));
    }

    @GET
    @Path(value="{ipAddress}/metadata/{context}/{key}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public OnmsMetaDataList getMetaData(@Context UriInfo uriInfo, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="context") String context, @PathParam(value="key") String key) {
        OnmsIpInterface intf = this.getInterface(uriInfo, ipAddress);
        if (intf == null) {
            throw NodeIpInterfacesRestService.getException(Response.Status.BAD_REQUEST, "getMetaData: Can't find interface " + ipAddress, new String[0]);
        }
        return new OnmsMetaDataList((Collection)intf.getMetaData().stream().filter(e -> context.equals(e.getContext()) && key.equals(e.getKey())).collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{ipAddress}/metadata/{context}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public Response deleteMetaData(@Context UriInfo uriInfo, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="context") String context) {
        NodeIpInterfacesRestService.checkUserDefinedMetadataContext(context);
        this.writeLock();
        try {
            OnmsIpInterface intf = this.getInterface(uriInfo, ipAddress);
            if (intf == null) {
                throw NodeIpInterfacesRestService.getException(Response.Status.BAD_REQUEST, "deleteMetaData: Can't find interface " + ipAddress, new String[0]);
            }
            intf.removeMetaData(context);
            this.getDao().update((Object)intf);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{ipAddress}/metadata/{context}/{key}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public Response deleteMetaData(@Context UriInfo uriInfo, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="context") String context, @PathParam(value="key") String key) {
        NodeIpInterfacesRestService.checkUserDefinedMetadataContext(context);
        this.writeLock();
        try {
            OnmsIpInterface intf = this.getInterface(uriInfo, ipAddress);
            if (intf == null) {
                throw NodeIpInterfacesRestService.getException(Response.Status.BAD_REQUEST, "deleteMetaData: Can't find interface " + ipAddress, new String[0]);
            }
            intf.removeMetaData(context, key);
            this.getDao().update((Object)intf);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{ipAddress}/metadata")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public Response postMetaData(@Context UriInfo uriInfo, @PathParam(value="ipAddress") String ipAddress, OnmsMetaData entity) {
        NodeIpInterfacesRestService.checkUserDefinedMetadataContext(entity.getContext());
        this.writeLock();
        try {
            OnmsIpInterface intf = this.getInterface(uriInfo, ipAddress);
            if (intf == null) {
                throw NodeIpInterfacesRestService.getException(Response.Status.BAD_REQUEST, "postMetaData: Can't find interface " + ipAddress, new String[0]);
            }
            intf.addMetaData(entity.getContext(), entity.getKey(), entity.getValue());
            this.getDao().update((Object)intf);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{ipAddress}/metadata/{context}/{key}/{value}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public Response putMetaData(@Context UriInfo uriInfo, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="context") String context, @PathParam(value="key") String key, @PathParam(value="value") String value) {
        NodeIpInterfacesRestService.checkUserDefinedMetadataContext(context);
        NodeIpInterfacesRestService.checkUserDefinedMetadataContext(context);
        this.writeLock();
        try {
            OnmsIpInterface intf = this.getInterface(uriInfo, ipAddress);
            if (intf == null) {
                throw NodeIpInterfacesRestService.getException(Response.Status.BAD_REQUEST, "putMetaData: Can't find interface " + ipAddress, new String[0]);
            }
            intf.addMetaData(context, key, value);
            this.getDao().update((Object)intf);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }
}

