/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.web.api.RestUtils;
import org.opennms.web.rest.model.v2.MonitoredServiceCollectionDTO;
import org.opennms.web.rest.model.v2.MonitoredServiceDTO;
import org.opennms.web.rest.model.v2.ServiceTypeDTO;
import org.opennms.web.rest.support.Aliases;
import org.opennms.web.rest.support.CriteriaBehavior;
import org.opennms.web.rest.support.CriteriaBehaviors;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.support.SearchProperties;
import org.opennms.web.rest.support.SearchProperty;
import org.opennms.web.rest.v2.AbstractDaoRestServiceWithDTO;
import org.opennms.web.rest.v2.ApplicationEventUtil;
import org.opennms.web.rest.v2.MonitoredServicesComponent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="ifservices")
@Transactional
public class IfServiceRestService
extends AbstractDaoRestServiceWithDTO<OnmsMonitoredService, MonitoredServiceDTO, SearchBean, Integer, String> {
    @Autowired
    private MonitoredServiceDao m_dao;
    @Autowired
    private MonitoredServicesComponent m_component;

    protected MonitoredServiceDao getDao() {
        return this.m_dao;
    }

    @Override
    protected Class<OnmsMonitoredService> getDaoClass() {
        return OnmsMonitoredService.class;
    }

    @Override
    protected Class<SearchBean> getQueryBeanClass() {
        return SearchBean.class;
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder(UriInfo uriInfo) {
        CriteriaBuilder builder = new CriteriaBuilder(this.getDaoClass());
        builder.alias("ipInterface", Aliases.ipInterface.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias("serviceType", Aliases.serviceType.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.ipInterface.prop("node"), Aliases.node.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.ipInterface.prop("snmpInterface"), Aliases.snmpInterface.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.node.prop("assetRecord"), Aliases.assetRecord.toString(), Alias.JoinType.LEFT_JOIN);
        builder.alias(Aliases.node.prop("location"), Aliases.location.toString(), Alias.JoinType.LEFT_JOIN);
        builder.orderBy("id");
        return builder;
    }

    @Override
    protected Set<SearchProperty> getQueryProperties() {
        return SearchProperties.IF_SERVICE_SERVICE_PROPERTIES;
    }

    @Override
    protected Map<String, CriteriaBehavior<?>> getCriteriaBehaviors() {
        HashMap map = new HashMap();
        map.putAll(CriteriaBehaviors.MONITORED_SERVICE_BEHAVIORS);
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.ipInterface, CriteriaBehaviors.IP_INTERFACE_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.serviceType, CriteriaBehaviors.SERVICE_TYPE_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.node, CriteriaBehaviors.NODE_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.snmpInterface, CriteriaBehaviors.SNMP_INTERFACE_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.assetRecord, CriteriaBehaviors.ASSET_RECORD_BEHAVIORS));
        map.putAll(CriteriaBehaviors.withAliasPrefix(Aliases.location, CriteriaBehaviors.MONITORING_LOCATION_BEHAVIORS));
        return map;
    }

    @Override
    protected JaxbListWrapper<MonitoredServiceDTO> createListWrapper(Collection<MonitoredServiceDTO> list) {
        return new MonitoredServiceCollectionDTO(list);
    }

    @Override
    public MonitoredServiceDTO mapEntityToDTO(OnmsMonitoredService entity) {
        MonitoredServiceDTO dto = new MonitoredServiceDTO();
        dto.setId(entity.getId());
        dto.setDown(Boolean.valueOf(entity.isDown()));
        dto.setNotify(entity.getNotify());
        dto.setStatus(entity.getStatus());
        dto.setSource(entity.getSource());
        ServiceTypeDTO serviceType = new ServiceTypeDTO();
        serviceType.setId(entity.getServiceId());
        serviceType.setName(entity.getServiceName());
        dto.setServiceType(serviceType);
        dto.setQualifier(entity.getQualifier());
        dto.setLastFail(entity.getLastFail());
        dto.setLastGood(entity.getLastGood());
        dto.setStatusLong(entity.getStatusLong());
        dto.setIpInterfaceId(entity.getIpInterfaceId());
        dto.setIpAddress(entity.getIpAddress().getHostAddress());
        dto.setNodeId(entity.getNodeId());
        dto.setNodeLabel(entity.getNodeLabel());
        return dto;
    }

    @Override
    public OnmsMonitoredService mapDTOToEntity(MonitoredServiceDTO dto) {
        OnmsMonitoredService service = new OnmsMonitoredService();
        service.setId(dto.getId());
        service.setNotify(dto.getNotify());
        service.setStatus(dto.getStatus());
        service.setSource(dto.getSource());
        OnmsServiceType serviceType = new OnmsServiceType();
        serviceType.setId(dto.getServiceType().getId());
        serviceType.setName(dto.getServiceType().getName());
        service.setServiceType(serviceType);
        service.setQualifier(dto.getQualifier());
        service.setLastFail(dto.getLastFail());
        service.setLastGood(dto.getLastGood());
        return service;
    }

    @Override
    protected Response doUpdateProperties(SecurityContext securityContext, UriInfo uriInfo, OnmsMonitoredService targetObject, MultivaluedMapImpl params) {
        String previousStatus = targetObject.getStatus();
        HashSet applicationsOriginal = new HashSet();
        if (targetObject.getApplications() != null) {
            applicationsOriginal.addAll(targetObject.getApplications());
        }
        RestUtils.setBeanProperties((Object)targetObject, (MultivaluedMap)params);
        this.getDao().update((Object)targetObject);
        Sets.SetView changedApplications = Sets.symmetricDifference(applicationsOriginal, (Set)targetObject.getApplications());
        ApplicationEventUtil.getApplicationChangedEvents((Collection<OnmsApplication>)changedApplications).forEach(this::sendEvent);
        boolean changed = this.m_component.hasStatusChanged(previousStatus, targetObject);
        return changed ? Response.noContent().build() : Response.notModified().build();
    }

    @Override
    protected OnmsMonitoredService doGet(UriInfo uriInfo, String serviceName) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build());
    }
}

