/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1.config;

import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opennms.core.config.api.ConfigurationResourceException;
import org.opennms.netmgt.config.JMXDataCollectionConfigDao;
import org.opennms.netmgt.config.collectd.jmx.JmxDatacollectionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component(value="jmxDataCollectionConfigResource")
public class JmxDataCollectionConfigResource
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(JmxDataCollectionConfigResource.class);
    @Resource(name="jmxDataCollectionConfigDao")
    private JMXDataCollectionConfigDao m_jmxDataCollectionConfigDao;

    public void setJmxDataCollectionConfigDao(JMXDataCollectionConfigDao dao) {
        this.m_jmxDataCollectionConfigDao = dao;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_jmxDataCollectionConfigDao, (String)"JmxDataCollectionConfigDao must be set!");
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response getJmxDataCollectionConfig() throws ConfigurationResourceException {
        LOG.debug("getJmxDataCollectionConfigurationForLocation()");
        JmxDatacollectionConfig jmxDataCollectionConfig = this.m_jmxDataCollectionConfigDao.getConfig();
        if (jmxDataCollectionConfig == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)jmxDataCollectionConfig).build();
    }
}

