/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.core.logging.Logging;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.dao.api.NotificationDao;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsNotificationCollection;
import org.opennms.netmgt.notifd.api.NotificationConfigProvider;
import org.opennms.netmgt.notifd.api.NotificationTester;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.NotificationSummary;
import org.opennms.web.rest.v1.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="notificationRestService")
@Path(value="notifications")
@Tag(name="Notifications", description="Notifications API")
public class NotificationRestService
extends OnmsRestService {
    @Autowired
    private NotificationDao m_notifDao;

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{notifId}")
    @Transactional
    public OnmsNotification getNotification(@PathParam(value="notifId") Integer notifId) {
        if (notifId == null) {
            throw NotificationRestService.getException(Response.Status.BAD_REQUEST, "Notification ID is required", new String[0]);
        }
        OnmsNotification notif = (OnmsNotification)this.m_notifDao.get((Serializable)notifId);
        if (notif == null) {
            throw NotificationRestService.getException(Response.Status.NOT_FOUND, "Notification {} was not found.", Integer.toString(notifId));
        }
        return notif;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        return Integer.toString(this.m_notifDao.countAll());
    }

    @GET
    @Path(value="summary")
    @Produces(value={"application/json"})
    public NotificationSummary getInfo(@Context SecurityContext securityContext) {
        String user = securityContext.getUserPrincipal().getName();
        NotificationSummary info = new NotificationSummary();
        info.setUser(user);
        info.setTotalCount(this.m_notifDao.countAll());
        info.setTotalUnacknowledgedCount(this.m_notifDao.countMatching(new CriteriaBuilder(OnmsNotification.class).isNull("answeredBy").toCriteria()));
        info.setUserUnacknowledgedCount(this.m_notifDao.countMatching(new CriteriaBuilder(OnmsNotification.class).isNull("answeredBy").alias("usersNotified", "usersNotified").eq("usersNotified.userId", (Object)user).toCriteria()));
        info.setTeamUnacknowledgedCount(this.m_notifDao.countMatching(new CriteriaBuilder(OnmsNotification.class).isNull("answeredBy").alias("usersNotified", "usersNotified", Alias.JoinType.LEFT_JOIN).or(new Restriction[]{Restrictions.ne((String)"usersNotified.userId", (Object)user), Restrictions.isNull((String)"usersNotified.userId")}).toCriteria()));
        if (info.getUserUnacknowledgedCount() != 0) {
            List newestNotifications = this.m_notifDao.findMatching(new CriteriaBuilder(OnmsNotification.class).isNull("answeredBy").alias("usersNotified", "usersNotified").eq("usersNotified.userId", (Object)user).orderBy("pageTime", false).limit(Integer.valueOf(10)).toCriteria());
            info.setUserUnacknowledgedNotifications(new OnmsNotificationCollection((Collection)newestNotifications));
        }
        return info;
    }

    @GET
    @Path(value="")
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    public OnmsNotificationCollection getNotifications(@Context UriInfo uriInfo) {
        CriteriaBuilder builder = NotificationRestService.getCriteriaBuilder((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        builder.orderBy("notifyId").desc();
        OnmsNotificationCollection coll = new OnmsNotificationCollection((Collection)this.m_notifDao.findMatching(builder.toCriteria()));
        coll.setTotalCount(Integer.valueOf(this.m_notifDao.countMatching(builder.count().toCriteria())));
        return coll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{notifId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateNotification(@Context SecurityContext securityContext, @PathParam(value="notifId") Integer notifId, @FormParam(value="ack") Boolean ack) {
        this.writeLock();
        try {
            if (ack == null) {
                throw NotificationRestService.getException(Response.Status.BAD_REQUEST, "Must supply the 'ack' parameter, set to either 'true' or 'false'", new String[0]);
            }
            OnmsNotification notif = this.getNotification(notifId);
            this.processNotifAck(securityContext, notif, ack);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateNotifications(@Context SecurityContext securityContext, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            Boolean ack = false;
            if (params.containsKey("ack")) {
                ack = "true".equals(params.getFirst("ack"));
                params.remove("ack");
            }
            CriteriaBuilder builder = NotificationRestService.getCriteriaBuilder(params);
            for (OnmsNotification notif : this.m_notifDao.findMatching(builder.toCriteria())) {
                this.processNotifAck(securityContext, notif, ack);
            }
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @POST
    @Path(value="destination-paths/{destinationPathName}/trigger")
    @Transactional
    public Response triggerDestinationPath(@Context SecurityContext securityContext, @PathParam(value="destinationPathName") String destinationPathName) {
        if (!securityContext.isUserInRole("ROLE_ADMIN")) {
            throw NotificationRestService.getException(Response.Status.FORBIDDEN, "User {} does not have access to trigger notifications.", securityContext.getUserPrincipal().getName());
        }
        NotificationConfigProvider notificationConfigProvider = (NotificationConfigProvider)BeanUtils.getBean((String)"notifdContext", (String)"notificationConfigProvider", NotificationConfigProvider.class);
        NotificationTester notificationTester = (NotificationTester)BeanUtils.getBean((String)"notifdContext", (String)"notificationTester", NotificationTester.class);
        List targetNames = notificationConfigProvider.getTargetNames(destinationPathName, false);
        if (targetNames.isEmpty()) {
            return Response.noContent().build();
        }
        for (String targetName : targetNames) {
            for (String command : notificationConfigProvider.getCommands(destinationPathName, targetName, false)) {
                Logging.MDCCloseable ignored = Logging.withPrefixCloseable((String)"notifd");
                try {
                    notificationTester.triggerNotificationsForTarget(targetName, command);
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
        }
        return Response.accepted().build();
    }

    private void processNotifAck(SecurityContext securityContext, OnmsNotification notif, Boolean ack) {
        if (ack.booleanValue()) {
            notif.setRespondTime(new Date());
            notif.setAnsweredBy(securityContext.getUserPrincipal().getName());
        } else {
            notif.setRespondTime(null);
            notif.setAnsweredBy(null);
        }
        this.m_notifDao.save((Object)notif);
    }

    private static CriteriaBuilder getCriteriaBuilder(MultivaluedMap<String, String> params) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNotification.class);
        builder.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        builder.alias("node.snmpInterfaces", "snmpInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("node.ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("event", "event", Alias.JoinType.LEFT_JOIN);
        builder.alias("usersNotified", "usersNotified", Alias.JoinType.LEFT_JOIN);
        NotificationRestService.applyQueryFilters(params, builder);
        return builder;
    }
}

