/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.graphml.status;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.opennms.features.topology.api.info.MeasurementsWrapper;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.api.topo.StatusProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLVertex;
import org.opennms.features.topology.plugins.topo.graphml.internal.AlarmSummaryWrapper;
import org.opennms.features.topology.plugins.topo.graphml.internal.GraphMLServiceAccessor;
import org.opennms.features.topology.plugins.topo.graphml.internal.Scripting;
import org.opennms.features.topology.plugins.topo.graphml.status.GraphMLVertexStatus;
import org.opennms.netmgt.model.alarm.AlarmSummary;

public class GraphMLScriptVertexStatusProvider
implements StatusProvider {
    private final String namespace;
    private final AlarmSummaryWrapper alarmSummaryWrapper;
    private final GraphMLServiceAccessor serviceAccessor;
    private final Scripting<GraphMLVertex, GraphMLVertexStatus> scripting;

    public GraphMLScriptVertexStatusProvider(String namespace, AlarmSummaryWrapper alarmSummaryWrapper, ScriptEngineManager scriptEngineManager, GraphMLServiceAccessor serviceAccessor, Path scriptPath) {
        this.namespace = Objects.requireNonNull(namespace);
        this.alarmSummaryWrapper = Objects.requireNonNull(alarmSummaryWrapper);
        this.serviceAccessor = Objects.requireNonNull(serviceAccessor);
        this.scripting = new Scripting(scriptPath, scriptEngineManager, GraphMLVertexStatus::new, GraphMLVertexStatus::merge);
    }

    public GraphMLScriptVertexStatusProvider(String namespace, AlarmSummaryWrapper alarmSummaryWrapper, ScriptEngineManager scriptEngineManager, GraphMLServiceAccessor serviceAccessor) {
        this(namespace, alarmSummaryWrapper, scriptEngineManager, serviceAccessor, Paths.get(System.getProperty("opennms.home"), "etc", "graphml-vertex-status"));
    }

    public Map<? extends VertexRef, ? extends Status> getStatusForVertices(BackendGraph graph, Collection<VertexRef> vertices, Criteria[] criteria) {
        List graphMLVertices = vertices.stream().filter(eachVertex -> this.contributesTo(eachVertex.getNamespace()) && eachVertex instanceof GraphMLVertex).map(eachVertex -> (GraphMLVertex)((Object)eachVertex)).collect(Collectors.toList());
        Map nodeIdToAlarmSummaryMap = this.alarmSummaryWrapper.getAlarmSummaries(Lists.transform(graphMLVertices, AbstractVertex::getNodeID)).stream().collect(Collectors.toMap(AlarmSummary::getNodeId, Function.identity()));
        return (Map)this.serviceAccessor.getTransactionOperations().execute(t -> this.scripting.compute(graphMLVertices.stream(), vertex -> {
            SimpleBindings bindings = new SimpleBindings();
            bindings.put("vertex", vertex);
            if (vertex.getNodeID() != null) {
                bindings.put("node", this.serviceAccessor.getNodeDao().get((Serializable)vertex.getNodeID()));
                bindings.put("alarmSummary", nodeIdToAlarmSummaryMap.get(vertex.getNodeID()));
            }
            bindings.put("measurements", (Object)new MeasurementsWrapper(this.serviceAccessor.getMeasurementsService()));
            bindings.put("nodeDao", (Object)this.serviceAccessor.getNodeDao());
            bindings.put("snmpInterfaceDao", (Object)this.serviceAccessor.getSnmpInterfaceDao());
            return bindings;
        }));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean contributesTo(String namespace) {
        return this.getNamespace().equals(namespace);
    }
}

