/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.graphml.status;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.api.topo.StatusProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLMetaTopologyProvider;
import org.opennms.features.topology.plugins.topo.graphml.status.GraphMLVertexStatus;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMLPropagateVertexStatusProvider
implements StatusProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GraphMLPropagateVertexStatusProvider.class);
    private final String namespace;
    private final GraphMLMetaTopologyProvider provider;
    private final BundleContext bundleContext;

    public GraphMLPropagateVertexStatusProvider(String namespace, GraphMLMetaTopologyProvider provider, BundleContext bundleContext) {
        this.namespace = Objects.requireNonNull(namespace);
        this.provider = Objects.requireNonNull(provider);
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<? extends VertexRef, ? extends Status> getStatusForVertices(BackendGraph graph, Collection<VertexRef> vertices, Criteria[] criteria) {
        ArrayList criteriaList = Lists.newArrayList((Object[])criteria);
        LoopDetectionCriteria loopDetectionCriteria = (LoopDetectionCriteria)((Object)Iterables.tryFind((Iterable)criteriaList, c -> c instanceof LoopDetectionCriteria).transform(c -> (LoopDetectionCriteria)((Object)c)).or(LoopDetectionCriteria::new));
        HashMultimap oppositeVertices = HashMultimap.create();
        for (VertexRef sourceVertex : vertices) {
            if (loopDetectionCriteria.contains(sourceVertex)) {
                LOG.error("Loop detected with: {}:{}", (Object)sourceVertex.getNamespace(), (Object)sourceVertex.getId());
                continue;
            }
            for (VertexRef targetVertex : this.provider.getOppositeVertices(sourceVertex)) {
                oppositeVertices.put((Object)targetVertex.getNamespace(), (Object)targetVertex);
            }
        }
        criteriaList.remove((Object)loopDetectionCriteria);
        criteriaList.add(loopDetectionCriteria.with(vertices));
        HashMap targetStatuses = Maps.newHashMap();
        try {
            Collection statusProviderReferences = this.bundleContext.getServiceReferences(StatusProvider.class, null);
            for (ServiceReference statusProviderReference : statusProviderReferences) {
                try {
                    StatusProvider statusProvider = (StatusProvider)this.bundleContext.getService(statusProviderReference);
                    for (Map.Entry entry : oppositeVertices.asMap().entrySet()) {
                        if (!statusProvider.contributesTo((String)entry.getKey())) continue;
                        targetStatuses.putAll(statusProvider.getStatusForVertices(this.provider.getGraphProviderBy((String)entry.getKey()).getCurrentGraph(), (Collection)entry.getValue(), criteriaList.toArray(new Criteria[0])));
                    }
                }
                finally {
                    this.bundleContext.ungetService(statusProviderReference);
                }
            }
        }
        catch (InvalidSyntaxException statusProviderReferences) {
            // empty catch block
        }
        HashMap statuses = Maps.newHashMap();
        for (VertexRef sourceVertex : vertices) {
            GraphMLVertexStatus mergedStatus = new GraphMLVertexStatus();
            for (VertexRef vertexRef : this.provider.getOppositeVertices(sourceVertex)) {
                if (!targetStatuses.containsKey(vertexRef)) continue;
                mergedStatus = GraphMLVertexStatus.merge(mergedStatus, (GraphMLVertexStatus)targetStatuses.get(vertexRef));
            }
            statuses.put(sourceVertex, mergedStatus);
        }
        return statuses;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean contributesTo(String namespace) {
        return this.getNamespace().equals(namespace);
    }

    private static class LoopDetectionCriteria
    extends Criteria {
        private final Set<VertexRef> seen = new HashSet<VertexRef>();

        private LoopDetectionCriteria(LoopDetectionCriteria that, Collection<VertexRef> vertices) {
            this();
            this.seen.addAll(that.seen);
            this.seen.addAll(vertices);
        }

        public LoopDetectionCriteria() {
        }

        public boolean contains(VertexRef vertex) {
            return this.seen.contains(vertex);
        }

        public Criteria.ElementType getType() {
            return Criteria.ElementType.VERTEX;
        }

        public String getNamespace() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LoopDetectionCriteria)) {
                return false;
            }
            LoopDetectionCriteria that = (LoopDetectionCriteria)((Object)o);
            return this.seen.equals(that.seen);
        }

        public int hashCode() {
            return this.seen.hashCode();
        }

        public LoopDetectionCriteria with(Collection<VertexRef> vertices) {
            return new LoopDetectionCriteria(this, Objects.requireNonNull(vertices));
        }
    }
}

