/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.graphml.status;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.Status;
import org.opennms.features.topology.api.topo.StatusProvider;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.graphml.GraphMLVertex;
import org.opennms.features.topology.plugins.topo.graphml.internal.AlarmSummaryWrapper;
import org.opennms.features.topology.plugins.topo.graphml.status.GraphMLVertexStatus;
import org.opennms.netmgt.model.alarm.AlarmSummary;

public class GraphMLDefaultVertexStatusProvider
implements StatusProvider {
    private final String namespace;
    private final AlarmSummaryWrapper alarmSummaryWrapper;

    public GraphMLDefaultVertexStatusProvider(String namespace, AlarmSummaryWrapper alarmSummaryWrapper) {
        this.namespace = Objects.requireNonNull(namespace);
        this.alarmSummaryWrapper = Objects.requireNonNull(alarmSummaryWrapper);
    }

    public boolean contributesTo(String namespace) {
        return this.getNamespace().equals(namespace);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<? extends VertexRef, ? extends Status> getStatusForVertices(BackendGraph graph, Collection<VertexRef> vertices, Criteria[] criteria) {
        List graphMLVertices = vertices.stream().filter(eachVertex -> this.contributesTo(eachVertex.getNamespace()) && eachVertex instanceof GraphMLVertex).map(eachVertex -> (GraphMLVertex)((Object)eachVertex)).collect(Collectors.toList());
        Map nodeIdMap = graphMLVertices.stream().filter(eachVertex -> eachVertex.getNodeID() != null).collect(Collectors.toMap(AbstractVertex::getNodeID, Function.identity()));
        Map<Integer, AlarmSummary> nodeIdToAlarmSummaryMap = this.getAlarmSummaries(nodeIdMap.keySet());
        HashMap resultMap = Maps.newHashMap();
        for (GraphMLVertex eachVertex2 : graphMLVertices) {
            AlarmSummary alarmSummary = nodeIdToAlarmSummaryMap.get(eachVertex2.getNodeID());
            GraphMLVertexStatus status = alarmSummary == null ? new GraphMLVertexStatus() : new GraphMLVertexStatus(alarmSummary.getMaxSeverity(), alarmSummary.getAlarmCount());
            resultMap.put(eachVertex2, status);
        }
        return resultMap;
    }

    private Map<Integer, AlarmSummary> getAlarmSummaries(Set<Integer> nodeIds) {
        return this.alarmSummaryWrapper.getAlarmSummaries(new ArrayList<Integer>(nodeIds)).stream().collect(Collectors.toMap(AlarmSummary::getNodeId, Function.identity()));
    }
}

