/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.graphml.internal;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.apache.commons.io.FilenameUtils;
import org.opennms.features.topology.api.topo.Ref;
import org.opennms.features.topology.api.topo.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scripting<E extends Ref, S extends Status> {
    private static final Logger LOG = LoggerFactory.getLogger(Scripting.class);
    private final Path scriptPath;
    private final ScriptEngineManager scriptEngineManager;
    private final Supplier<S> statusDefault;
    private final BinaryOperator<S> statusAccumulator;

    public Scripting(Path scriptPath, ScriptEngineManager scriptEngineManager, Supplier<S> statusDefault, BinaryOperator<S> statusAccumulator) {
        this.scriptPath = Objects.requireNonNull(scriptPath);
        this.scriptEngineManager = Objects.requireNonNull(scriptEngineManager);
        this.statusDefault = Objects.requireNonNull(statusDefault);
        this.statusAccumulator = Objects.requireNonNull(statusAccumulator);
    }

    private List<StatusScript<S>> loadScripts() {
        ArrayList scripts = Lists.newArrayList();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.scriptPath);){
            for (Path path : stream) {
                String extension = FilenameUtils.getExtension((String)path.toString());
                ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByExtension(extension);
                if (scriptEngine == null) {
                    LOG.warn("No script engine found for extension '{}'", (Object)extension);
                    continue;
                }
                LOG.debug("Found script: path={}, extension={}, engine={}", new Object[]{path, extension, scriptEngine});
                Stream<String> lines = Files.lines(path, Charset.defaultCharset());
                try {
                    String source = lines.collect(Collectors.joining("\n"));
                    scripts.add(new StatusScript(scriptEngine, source));
                }
                finally {
                    if (lines == null) continue;
                    lines.close();
                }
            }
        }
        catch (IOException e) {
            LOG.error("Failed to walk template directory: " + this.scriptPath, (Throwable)e);
            return Collections.emptyList();
        }
        return scripts;
    }

    private S computeStatus(List<StatusScript<S>> scripts, E element, Function<E, SimpleBindings> refBindingMapper) {
        return (S)scripts.stream().flatMap(script -> {
            SimpleBindings bindings = (SimpleBindings)refBindingMapper.apply(element);
            StringWriter writer = new StringWriter();
            SimpleScriptContext context = new SimpleScriptContext();
            context.setWriter(writer);
            context.setBindings(bindings, 200);
            try {
                LOG.debug("Executing script: {}", script);
                Object status = script.eval(context);
                if (status != null) {
                    Stream stream = Stream.of(status);
                    return stream;
                }
                Stream stream = Stream.empty();
                return stream;
            }
            catch (ScriptException e) {
                LOG.error("Failed to execute script: {}", (Throwable)e);
                Stream stream = Stream.empty();
                return stream;
            }
            finally {
                LOG.info(writer.toString());
            }
        }).filter(Objects::nonNull).reduce(this.statusAccumulator).orElseGet(this.statusDefault);
    }

    public Map<E, S> compute(Stream<E> elements, Function<E, SimpleBindings> refBindingMapper) {
        List<StatusScript<S>> scripts = this.loadScripts();
        return elements.map(element -> new AbstractMap.SimpleEntry<Ref, S>((Ref)element, this.computeStatus(scripts, element, refBindingMapper))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static class StatusScript<S extends Status> {
        private final ScriptEngine engine;
        private final String source;
        private Optional<CompiledScript> compiledScript = null;

        private StatusScript(ScriptEngine engine, String source) {
            this.engine = Objects.requireNonNull(engine);
            this.source = Objects.requireNonNull(source);
        }

        public S eval(ScriptContext context) throws ScriptException {
            if (this.compiledScript == null) {
                this.compiledScript = this.engine instanceof Compilable ? Optional.of(((Compilable)((Object)this.engine)).compile(this.source)) : Optional.empty();
            }
            if (this.compiledScript.isPresent()) {
                return (S)((Status)this.compiledScript.get().eval(context));
            }
            return (S)((Status)this.engine.eval(this.source, context));
        }
    }
}

