/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseLogin;

public abstract class EclipseLinkException
extends RuntimeException {
    protected transient AbstractSession session;
    protected Throwable internalException;
    protected static Boolean shouldPrintInternalException = null;
    protected String indentationString = "";
    protected int errorCode;
    protected static final String CR = System.getProperty("line.separator");
    protected boolean hasBeenLogged = false;

    public EclipseLinkException() {
        this("");
    }

    public EclipseLinkException(String theMessage) {
        super(theMessage);
    }

    public EclipseLinkException(String message, Throwable internalException) {
        this(message);
        this.setInternalException(internalException);
    }

    protected static String cr() {
        return Helper.cr();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getIndentationString() {
        return this.indentationString;
    }

    public Throwable getInternalException() {
        return this.internalException;
    }

    @Override
    public String getMessage() {
        StringWriter writer = new StringWriter(100);
        if (this.getInternalException() == null || super.getMessage() != null && !super.getMessage().equals(this.getInternalException().toString())) {
            writer.write(EclipseLinkException.cr());
            writer.write(this.getIndentationString());
            writer.write(ExceptionMessageGenerator.getHeader("DescriptionHeader"));
            writer.write(super.getMessage());
        }
        if (this.getInternalException() != null) {
            writer.write(EclipseLinkException.cr());
            writer.write(this.getIndentationString());
            writer.write(ExceptionMessageGenerator.getHeader("InternalExceptionHeader"));
            writer.write(this.getInternalException().toString());
            if (this.getInternalException() instanceof InvocationTargetException && ((InvocationTargetException)this.getInternalException()).getTargetException() != null) {
                writer.write(EclipseLinkException.cr());
                writer.write(this.getIndentationString());
                writer.write(ExceptionMessageGenerator.getHeader("TargetInvocationExceptionHeader"));
                writer.write(((InvocationTargetException)this.getInternalException()).getTargetException().toString());
            }
        }
        return writer.toString();
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public boolean hasBeenLogged() {
        return this.hasBeenLogged;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream outStream) {
        this.printStackTrace(new PrintWriter(outStream));
    }

    @Override
    public void printStackTrace(PrintWriter writer) {
        writer.write(ExceptionMessageGenerator.getHeader("LocalExceptionStackHeader"));
        writer.write(EclipseLinkException.cr());
        super.printStackTrace(writer);
        if (this.getInternalException() != null && EclipseLinkException.shouldPrintInternalException()) {
            writer.write(ExceptionMessageGenerator.getHeader("InternalExceptionStackHeader"));
            writer.write(EclipseLinkException.cr());
            this.getInternalException().printStackTrace(writer);
            if (this.getInternalException() instanceof InvocationTargetException && ((InvocationTargetException)this.getInternalException()).getTargetException() != null) {
                writer.write(ExceptionMessageGenerator.getHeader("TargetInvocationExceptionStackHeader"));
                writer.write(EclipseLinkException.cr());
                ((InvocationTargetException)this.getInternalException()).getTargetException().printStackTrace(writer);
            }
        }
        writer.flush();
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setHasBeenLogged(boolean logged) {
        this.hasBeenLogged = logged;
    }

    public void setIndentationString(String indentationString) {
        this.indentationString = indentationString;
    }

    public void setInternalException(Throwable exception) {
        this.internalException = exception;
        if (this.getCause() == null) {
            this.initCause(exception);
        }
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    public static void setShouldPrintInternalException(boolean printException) {
        shouldPrintInternalException = printException;
    }

    public static boolean shouldPrintInternalException() {
        if (shouldPrintInternalException == null) {
            shouldPrintInternalException = Boolean.FALSE;
        }
        return shouldPrintInternalException;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getIndentationString()) + ExceptionMessageGenerator.getHeader("ExceptionHeader") + this.getErrorCode() + "] (" + DatabaseLogin.getVersion() + "): " + this.getClass().getName() + this.getMessage();
    }
}

