/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.requisition.command;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.provision.persist.LocationAwareRequisitionClient;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.requisition.command.ImportRequisition;
import org.opennms.netmgt.provision.requisition.command.ProviderTypeNameCompleter;

@Command(scope="opennms", name="show-import", description="Display the resulting requisition generated by a given URL")
@Service
public class ShowImport
implements Action {
    @Reference
    private EventForwarder eventForwarder;
    @Option(name="-l", aliases={"--location"}, description="Location", required=false, multiValued=false)
    String location;
    @Option(name="-s", aliases={"--system-id"}, description="System ID")
    String systemId;
    @Option(name="-t", aliases={"--ttl"}, description="Time to live", required=false, multiValued=false)
    Long ttlInMs;
    @Option(name="-x", aliases={"--xml"}, description="XML Output", required=false, multiValued=false)
    boolean xmlOutput = false;
    @Option(name="-i", aliases={"--import"}, description="Import Requisition", required=false, multiValued=false)
    boolean importRequisition = false;
    @Argument(index=0, name="type", description="Type", required=true, multiValued=false)
    @Completion(value=ProviderTypeNameCompleter.class)
    String type;
    @Argument(index=1, name="parameters", description="Provide parameters in key=value form", multiValued=true)
    List<String> parameters;
    @Reference
    private LocationAwareRequisitionClient client;

    public Object execute() throws Exception {
        CompletableFuture future = this.client.requisition().withRequisitionProviderType(this.type).withParameters(ShowImport.parse(this.parameters)).withLocation(this.location).withSystemId(this.systemId).withTimeToLive(this.ttlInMs).execute();
        while (true) {
            try {
                try {
                    Requisition requisition = (Requisition)future.get(1L, TimeUnit.SECONDS);
                    if (this.importRequisition) {
                        System.out.println();
                        ImportRequisition.sendImportRequisitionEvent(this.eventForwarder, this.type, this.parameters, null, false, null);
                        System.out.println();
                    }
                    if (this.xmlOutput) {
                        return JaxbUtils.marshal((Object)requisition);
                    }
                    return requisition;
                }
                catch (InterruptedException e) {
                    System.out.println("\nInterrupted.");
                }
                catch (ExecutionException e) {
                    System.out.printf("\nRequisition retrieval failed with: %s\n", e);
                    e.printStackTrace();
                }
            }
            catch (TimeoutException timeoutException) {
                System.out.print(".");
                System.out.flush();
                continue;
            }
            break;
        }
        return null;
    }

    private static Map<String, String> parse(List<String> attributeList) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (attributeList != null) {
            for (String keyValue : attributeList) {
                int splitAt = keyValue.indexOf("=");
                if (splitAt <= 0) {
                    throw new IllegalArgumentException("Invalid property " + keyValue);
                }
                String key = keyValue.substring(0, splitAt);
                String value = keyValue.substring(splitAt + 1, keyValue.length());
                properties.put(key, value);
            }
        }
        return properties;
    }
}

