/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.persistence.impl;

import java.util.List;
import java.util.Objects;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.flows.classification.persistence.api.ClassificationRuleDao;
import org.opennms.netmgt.flows.classification.persistence.api.Group;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;

public class ClassificationRuleDaoImpl
extends AbstractDaoHibernate<Rule, Integer>
implements ClassificationRuleDao {
    public ClassificationRuleDaoImpl() {
        super(Rule.class);
    }

    @Override
    public List<Rule> findAllEnabledRules() {
        return this.findMatching(new CriteriaBuilder(Rule.class).alias("group", "group").eq("group.enabled", (Object)true).toCriteria());
    }

    @Override
    public Rule findByDefinition(Rule rule, Group group) {
        List matchingRules;
        Objects.requireNonNull(rule);
        Objects.requireNonNull(group);
        CriteriaBuilder criteriaBuilder = ClassificationRuleDaoImpl.createCriteriaBuilderDefinition(rule);
        criteriaBuilder.alias("group", "group");
        criteriaBuilder.eq("group.id", (Object)group.getId());
        if (rule.getId() != null) {
            criteriaBuilder.not().eq("id", (Object)rule.getId());
        }
        return (matchingRules = this.findMatching(criteriaBuilder.toCriteria())).isEmpty() ? null : (Rule)matchingRules.get(0);
    }

    @Override
    public List<Rule> findByDefinition(Rule rule) {
        Objects.requireNonNull(rule);
        CriteriaBuilder builder = ClassificationRuleDaoImpl.createCriteriaBuilderDefinition(rule);
        List<Rule> matchingRules = this.findMatching(builder.toCriteria());
        return matchingRules;
    }

    private static CriteriaBuilder createCriteriaBuilderDefinition(Rule rule) {
        CriteriaBuilder builder = new CriteriaBuilder(Rule.class);
        if (rule.hasDstAddressDefinition()) {
            builder.ilike("dstAddress", (Object)rule.getDstAddress());
        } else {
            builder.isNull("dstAddress");
        }
        if (rule.hasDstPortDefinition()) {
            builder.ilike("dstPort", (Object)rule.getDstPort());
        } else {
            builder.isNull("dstPort");
        }
        if (rule.hasSrcAddressDefinition()) {
            builder.ilike("srcAddress", (Object)rule.getSrcAddress());
        } else {
            builder.isNull("srcAddress");
        }
        if (rule.hasSrcPortDefinition()) {
            builder.ilike("srcPort", (Object)rule.getSrcPort());
        } else {
            builder.isNull("srcPort");
        }
        if (rule.hasProtocolDefinition()) {
            builder.ilike("protocol", (Object)rule.getProtocol());
        } else {
            builder.isNull("protocol");
        }
        if (rule.hasExportFilterDefinition()) {
            builder.ilike("exporterFilter", (Object)rule.getExporterFilter());
        } else {
            builder.isNull("exporterFilter");
        }
        return builder;
    }
}

