/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.model.LldpElement;
import org.opennms.netmgt.enlinkd.model.LldpElementTopologyEntity;
import org.opennms.netmgt.enlinkd.model.LldpLink;
import org.opennms.netmgt.enlinkd.model.LldpLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.persistence.api.LldpElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.LldpLinkDao;
import org.opennms.netmgt.enlinkd.service.api.CompositeKey;
import org.opennms.netmgt.enlinkd.service.api.LldpTopologyService;
import org.opennms.netmgt.enlinkd.service.api.TopologyConnection;
import org.opennms.netmgt.enlinkd.service.api.TopologyService;
import org.opennms.netmgt.enlinkd.service.impl.TopologyServiceImpl;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class LldpTopologyServiceImpl
extends TopologyServiceImpl
implements LldpTopologyService {
    private static final Logger LOG = LoggerFactory.getLogger(LldpTopologyServiceImpl.class);
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private LldpLinkDao m_lldpLinkDao;
    private LldpElementDao m_lldpElementDao;

    @Override
    public void delete(int nodeid) {
        this.m_lldpElementDao.deleteByNodeId(nodeid);
        this.m_lldpLinkDao.deleteByNodeId(nodeid);
        this.m_lldpElementDao.flush();
        this.m_lldpLinkDao.flush();
    }

    @Override
    public void reconcile(int nodeId, Date now) {
        LldpElement element = (LldpElement)this.m_lldpElementDao.findByNodeId(nodeId);
        if (element != null && element.getLldpNodeLastPollTime().getTime() < now.getTime()) {
            this.m_lldpElementDao.delete(element);
            this.m_lldpElementDao.flush();
        }
        this.m_lldpLinkDao.deleteByNodeIdOlderThen(nodeId, now);
        this.m_lldpLinkDao.flush();
    }

    @Override
    public void store(int nodeId, LldpLink link) {
        if (link == null) {
            return;
        }
        if (link.getLldpPortIfindex() == null) {
            LOG.debug("store: ifindex is null, {}", (Object)link);
            link.setLldpPortIfindex(this.m_lldpLinkDao.getIfIndex(nodeId, link.getLldpPortId()));
        }
        this.saveLldpLink(nodeId, link);
        this.updatesAvailable();
    }

    @Transactional
    protected void saveLldpLink(final int nodeId, final LldpLink saveMe) {
        new UpsertTemplate<LldpLink, LldpLinkDao>(this.m_transactionManager, this.m_lldpLinkDao){

            @Override
            protected LldpLink query() {
                return ((LldpLinkDao)this.m_dao).get(nodeId, saveMe.getLldpRemLocalPortNum(), saveMe.getLldpRemIndex());
            }

            @Override
            protected LldpLink doUpdate(LldpLink dbLldpLink) {
                dbLldpLink.merge(saveMe);
                ((LldpLinkDao)this.m_dao).update(dbLldpLink);
                ((LldpLinkDao)this.m_dao).flush();
                return dbLldpLink;
            }

            @Override
            protected LldpLink doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setNode(node);
                saveMe.setLldpLinkLastPollTime(saveMe.getLldpLinkCreateTime());
                ((LldpLinkDao)this.m_dao).saveOrUpdate(saveMe);
                ((LldpLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    @Transactional
    public void store(int nodeId, LldpElement element) {
        if (element == null) {
            return;
        }
        LldpElement dbelement = (LldpElement)this.m_lldpElementDao.findByNodeId(nodeId);
        if (dbelement != null) {
            dbelement.merge(element);
            this.m_lldpElementDao.saveOrUpdate(dbelement);
            this.m_lldpElementDao.flush();
            return;
        }
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(nodeId));
        element.setNode(node);
        element.setLldpNodeLastPollTime(element.getLldpNodeCreateTime());
        this.m_lldpElementDao.saveOrUpdate(element);
        this.m_lldpElementDao.flush();
        this.updatesAvailable();
    }

    public LldpLinkDao getLldpLinkDao() {
        return this.m_lldpLinkDao;
    }

    public void setLldpLinkDao(LldpLinkDao lldpLinkDao) {
        this.m_lldpLinkDao = lldpLinkDao;
    }

    public LldpElementDao getLldpElementDao() {
        return this.m_lldpElementDao;
    }

    public void setLldpElementDao(LldpElementDao lldpElementDao) {
        this.m_lldpElementDao = lldpElementDao;
    }

    @Override
    public List<LldpElementTopologyEntity> findAllLldpElements() {
        return this.getTopologyEntityCache().getLldpElementTopologyEntities();
    }

    @Override
    public List<TopologyConnection<LldpLinkTopologyEntity, LldpLinkTopologyEntity>> match() {
        LldpLinkTopologyEntity targetLink;
        Map<Integer, LldpElementTopologyEntity> nodelldpelementidMap = this.getTopologyEntityCache().getLldpElementTopologyEntities().stream().collect(Collectors.toMap(LldpElementTopologyEntity::getNodeId, lldpelem -> lldpelem));
        List<LldpLinkTopologyEntity> lldpLinks = this.getTopologyEntityCache().getLldpLinkTopologyEntities();
        HashMap<CompositeKey, LldpLinkTopologyEntity> lldpLinkCompositeKeyMap = new HashMap<CompositeKey, LldpLinkTopologyEntity>();
        for (LldpLinkTopologyEntity lldpLink : lldpLinks) {
            CompositeKey key = new CompositeKey(lldpLink.getLldpRemChassisId(), nodelldpelementidMap.get(lldpLink.getNodeId()).getLldpChassisId(), lldpLink.getLldpPortId(), lldpLink.getLldpPortIdSubType(), lldpLink.getLldpRemPortId(), lldpLink.getLldpRemPortIdSubType());
            lldpLinkCompositeKeyMap.put(key, lldpLink);
            CompositeKey descrkey = new CompositeKey(lldpLink.getLldpRemChassisId(), nodelldpelementidMap.get(lldpLink.getNodeId()).getLldpChassisId(), lldpLink.getLldpPortDescr(), lldpLink.getLldpRemPortDescr());
            lldpLinkCompositeKeyMap.put(descrkey, lldpLink);
            CompositeKey sysnameKey = new CompositeKey(lldpLink.getLldpRemSysname(), nodelldpelementidMap.get(lldpLink.getNodeId()).getLldpSysname(), lldpLink.getLldpPortId(), lldpLink.getLldpPortIdSubType(), lldpLink.getLldpRemPortId(), lldpLink.getLldpRemPortIdSubType());
            lldpLinkCompositeKeyMap.put(sysnameKey, lldpLink);
            CompositeKey elementaryKeyA = new CompositeKey(lldpLink.getLldpRemChassisId(), nodelldpelementidMap.get(lldpLink.getNodeId()).getLldpChassisId(), lldpLink.getLldpRemPortId(), lldpLink.getLldpRemPortIdSubType());
            lldpLinkCompositeKeyMap.put(elementaryKeyA, lldpLink);
            CompositeKey elementaryKeyB = new CompositeKey(lldpLink.getLldpRemChassisId(), nodelldpelementidMap.get(lldpLink.getNodeId()).getLldpChassisId(), lldpLink.getLldpRemPortDescr());
            lldpLinkCompositeKeyMap.put(elementaryKeyB, lldpLink);
            CompositeKey elementaryKeyC = new CompositeKey(lldpLink.getLldpRemChassisId(), nodelldpelementidMap.get(lldpLink.getNodeId()).getLldpChassisId());
            lldpLinkCompositeKeyMap.put(elementaryKeyC, lldpLink);
        }
        HashSet<Integer> parsed = new HashSet<Integer>();
        ArrayList<TopologyConnection<LldpLinkTopologyEntity, LldpLinkTopologyEntity>> results = new ArrayList<TopologyConnection<LldpLinkTopologyEntity, LldpLinkTopologyEntity>>();
        for (LldpLinkTopologyEntity sourceLink : lldpLinks) {
            if (parsed.contains(sourceLink.getId())) continue;
            if (nodelldpelementidMap.get(sourceLink.getNodeId()).getLldpChassisId().equals(sourceLink.getLldpRemChassisId()) || nodelldpelementidMap.get(sourceLink.getNodeId()).getLldpSysname().equals(sourceLink.getLldpRemSysname())) {
                LOG.info("match: self link, skipping:{}", (Object)sourceLink);
                parsed.add(sourceLink.getId());
                continue;
            }
            CompositeKey key = new CompositeKey(nodelldpelementidMap.get(sourceLink.getNodeId()).getLldpChassisId(), sourceLink.getLldpRemChassisId(), sourceLink.getLldpRemPortId(), sourceLink.getLldpRemPortIdSubType(), sourceLink.getLldpPortId(), sourceLink.getLldpPortIdSubType());
            targetLink = (LldpLinkTopologyEntity)lldpLinkCompositeKeyMap.get(key);
            if (targetLink == null) continue;
            LOG.info("match: default, source:{}, target:{}", (Object)sourceLink, (Object)targetLink);
            parsed.add(sourceLink.getId());
            parsed.add(targetLink.getId());
            results.add(TopologyService.of(sourceLink, targetLink));
        }
        for (LldpLinkTopologyEntity sourceLink : lldpLinks) {
            CompositeKey descrkey;
            if (parsed.contains(sourceLink.getId()) || (targetLink = (LldpLinkTopologyEntity)lldpLinkCompositeKeyMap.get(descrkey = new CompositeKey(nodelldpelementidMap.get(sourceLink.getNodeId()).getLldpChassisId(), sourceLink.getLldpRemChassisId(), sourceLink.getLldpRemPortDescr(), sourceLink.getLldpPortDescr()))) == null) continue;
            LOG.info("match: port description, source:{}, target:{}", (Object)sourceLink, (Object)targetLink);
            parsed.add(sourceLink.getId());
            parsed.add(targetLink.getId());
            results.add(TopologyService.of(sourceLink, targetLink));
        }
        for (LldpLinkTopologyEntity sourceLink : lldpLinks) {
            CompositeKey sysnamekey;
            if (parsed.contains(sourceLink.getId()) || (targetLink = (LldpLinkTopologyEntity)lldpLinkCompositeKeyMap.get(sysnamekey = new CompositeKey(nodelldpelementidMap.get(sourceLink.getNodeId()).getLldpSysname(), sourceLink.getLldpRemSysname(), sourceLink.getLldpRemPortId(), sourceLink.getLldpRemPortIdSubType(), sourceLink.getLldpPortId(), sourceLink.getLldpPortIdSubType()))) == null) continue;
            LOG.info("match: sysname , source:{}, target:{}", (Object)sourceLink, (Object)targetLink);
            parsed.add(sourceLink.getId());
            parsed.add(targetLink.getId());
            results.add(TopologyService.of(sourceLink, targetLink));
        }
        for (LldpLinkTopologyEntity sourceLink : lldpLinks) {
            CompositeKey elementaryA;
            if (parsed.contains(sourceLink.getId()) || (targetLink = (LldpLinkTopologyEntity)lldpLinkCompositeKeyMap.get(elementaryA = new CompositeKey(nodelldpelementidMap.get(sourceLink.getNodeId()).getLldpChassisId(), sourceLink.getLldpRemChassisId(), sourceLink.getLldpPortId(), sourceLink.getLldpPortIdSubType()))) == null) continue;
            LOG.info("match: chassis id/port/type , source:{}, target:{}", (Object)sourceLink, (Object)targetLink);
            parsed.add(sourceLink.getId());
            parsed.add(targetLink.getId());
            results.add(TopologyService.of(sourceLink, targetLink));
        }
        for (LldpLinkTopologyEntity sourceLink : lldpLinks) {
            CompositeKey elementaryB;
            if (parsed.contains(sourceLink.getId()) || (targetLink = (LldpLinkTopologyEntity)lldpLinkCompositeKeyMap.get(elementaryB = new CompositeKey(nodelldpelementidMap.get(sourceLink.getNodeId()).getLldpChassisId(), sourceLink.getLldpRemChassisId(), sourceLink.getLldpPortDescr()))) == null) continue;
            LOG.info("match: chassis id/portdescr , source:{}, target:{}", (Object)sourceLink, (Object)targetLink);
            parsed.add(sourceLink.getId());
            parsed.add(targetLink.getId());
            results.add(TopologyService.of(sourceLink, targetLink));
        }
        for (LldpLinkTopologyEntity sourceLink : lldpLinks) {
            CompositeKey elementaryC;
            if (parsed.contains(sourceLink.getId()) || (targetLink = (LldpLinkTopologyEntity)lldpLinkCompositeKeyMap.get(elementaryC = new CompositeKey(nodelldpelementidMap.get(sourceLink.getNodeId()).getLldpChassisId(), sourceLink.getLldpRemChassisId()))) == null) continue;
            LOG.info("match: chassis, source:{}, target:{}", (Object)sourceLink, (Object)targetLink);
            parsed.add(sourceLink.getId());
            parsed.add(targetLink.getId());
            results.add(TopologyService.of(sourceLink, targetLink));
        }
        return results;
    }

    @Override
    public void deletePersistedData() {
        this.m_lldpElementDao.deleteAll();
        this.m_lldpElementDao.flush();
        this.m_lldpLinkDao.deleteAll();
        this.m_lldpLinkDao.flush();
    }
}

