/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.api;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.dao.api.LegacyOnmsDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.SurveillanceStatus;
import org.springframework.stereotype.Repository;

@Repository
public interface NodeDao
extends LegacyOnmsDao<OnmsNode, Integer> {
    @Override
    public OnmsNode get(String var1);

    public Map<Integer, String> getAllLabelsById();

    public String getLabelForId(Integer var1);

    public String getLocationForId(Integer var1);

    public List<OnmsNode> findByLabel(String var1);

    public List<OnmsNode> findByLabelForLocation(String var1, String var2);

    public OnmsNode getHierarchy(Integer var1);

    public Map<String, Integer> getForeignIdToNodeIdMap(String var1);

    public Map<String, Set<String>> getForeignIdsPerForeignSourceMap();

    public Set<String> getForeignIdsPerForeignSource(String var1);

    public List<OnmsNode> findAllByVarCharAssetColumn(String var1, String var2);

    public List<OnmsNode> findAllByVarCharAssetColumnCategoryList(String var1, String var2, Collection<OnmsCategory> var3);

    public List<OnmsNode> findByCategory(OnmsCategory var1);

    public List<OnmsNode> findAllByCategoryList(Collection<OnmsCategory> var1);

    public List<OnmsNode> findAllByCategoryLists(Collection<OnmsCategory> var1, Collection<OnmsCategory> var2);

    @Override
    public List<OnmsNode> findAll();

    public List<OnmsNode> findByForeignSource(String var1);

    public OnmsNode findByForeignId(String var1, String var2);

    public List<OnmsNode> findByForeignId(String var1);

    public List<OnmsNode> findByForeignIdForLocation(String var1, String var2);

    public List<OnmsNode> findByIpAddressAndService(InetAddress var1, String var2);

    public int getNodeCountForForeignSource(String var1);

    public List<OnmsNode> findAllProvisionedNodes();

    public List<OnmsIpInterface> findObsoleteIpInterfaces(Integer var1, Date var2);

    public void deleteObsoleteInterfaces(Integer var1, Date var2);

    public void updateNodeScanStamp(Integer var1, Date var2);

    public Collection<Integer> getNodeIds();

    public List<OnmsNode> findByForeignSourceAndIpAddress(String var1, String var2);

    public Map<String, Long> getNumberOfNodesBySysOid();

    public SurveillanceStatus findSurveillanceStatusByCategoryLists(Collection<OnmsCategory> var1, Collection<OnmsCategory> var2);

    public Integer getNextNodeId(Integer var1);

    public Integer getPreviousNodeId(Integer var1);

    public void markHavingFlows(Collection<Integer> var1, Collection<Integer> var2);

    public List<OnmsNode> findAllHavingFlows();

    public List<OnmsNode> findAllHavingIngressFlows();

    public List<OnmsNode> findAllHavingEgressFlows();

    public OnmsNode getDefaultFocusPoint();

    public List<OnmsNode> findNodeWithMetaData(String var1, String var2, String var3, boolean var4);

    default public List<OnmsNode> findNodeWithMetaData(String context, String key, String value) {
        return this.findNodeWithMetaData(context, key, value, false);
    }

    public List<OnmsNode> findBySysNameOfLldpLinksOfNode(int var1);
}

