/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.soa.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opennms.core.soa.Filter;
import org.opennms.core.soa.Registration;
import org.opennms.core.soa.RegistrationHook;
import org.opennms.core.soa.RegistrationListener;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.soa.filter.FilterParser;
import org.opennms.core.soa.support.MultivaluedMap;
import org.opennms.core.soa.support.MultivaluedMapImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceRegistry
implements ServiceRegistry {
    private static Logger LOG = LoggerFactory.getLogger(DefaultServiceRegistry.class);
    public static final DefaultServiceRegistry INSTANCE = new DefaultServiceRegistry();
    private MultivaluedMap<Class<?>, ServiceRegistration> m_registrationMap = MultivaluedMapImpl.synchronizedMultivaluedMap();
    private MultivaluedMap<Class<?>, RegistrationListener<?>> m_listenerMap = MultivaluedMapImpl.synchronizedMultivaluedMap();
    private List<RegistrationHook> m_hooks = new CopyOnWriteArrayList<RegistrationHook>();

    @Override
    public <T> T findProvider(Class<T> serviceInterface) {
        return this.findProvider(serviceInterface, null);
    }

    @Override
    public <T> T findProvider(Class<T> serviceInterface, String filter) {
        Collection<T> providers = this.findProviders(serviceInterface, filter);
        Iterator<T> iterator = providers.iterator();
        if (iterator.hasNext()) {
            T provider = iterator.next();
            return provider;
        }
        return null;
    }

    @Override
    public <T> Collection<T> findProviders(Class<T> serviceInterface) {
        return this.findProviders(serviceInterface, null);
    }

    @Override
    public <T> Collection<T> findProviders(Class<T> serviceInterface, String filter) {
        AnyFilter f = filter == null ? new AnyFilter() : new FilterParser().parse(filter);
        Set<ServiceRegistration> registrations = this.getRegistrations(serviceInterface);
        LinkedHashSet<T> providers = new LinkedHashSet<T>(registrations.size());
        for (ServiceRegistration registration : registrations) {
            if (!f.match(registration.getProperties())) continue;
            providers.add(registration.getProvider(serviceInterface));
        }
        return providers;
    }

    @Override
    public Registration register(Object serviceProvider, Class<?> ... services) {
        return this.register(serviceProvider, (Map<String, String>)null, services);
    }

    @Override
    public Registration register(Object serviceProvider, Map<String, String> properties, Class<?> ... services) {
        ServiceRegistration registration = new ServiceRegistration(serviceProvider, properties, services);
        for (Class<?> serviceInterface : services) {
            this.m_registrationMap.add(serviceInterface, registration);
        }
        this.fireRegistrationAdded(registration);
        for (Class<?> serviceInterface : services) {
            this.fireProviderRegistered(serviceInterface, registration);
        }
        LOG.debug("Registered {} as instance of {}", serviceProvider, services);
        return registration;
    }

    private void fireRegistrationAdded(ServiceRegistration registration) {
        for (RegistrationHook hook : this.m_hooks) {
            hook.registrationAdded(registration);
        }
    }

    private void fireRegistrationRemoved(ServiceRegistration registration) {
        for (RegistrationHook hook : this.m_hooks) {
            hook.registrationRemoved(registration);
        }
    }

    private <T> Set<ServiceRegistration> getRegistrations(Class<T> serviceInterface) {
        Set<ServiceRegistration> copy = this.m_registrationMap.getCopy(serviceInterface);
        return copy == null ? Collections.emptySet() : copy;
    }

    private void unregister(ServiceRegistration registration) {
        for (Class<?> serviceInterface : registration.getProvidedInterfaces()) {
            this.m_registrationMap.remove(serviceInterface, registration);
        }
        this.fireRegistrationRemoved(registration);
        for (Class<?> serviceInterface : registration.getProvidedInterfaces()) {
            this.fireProviderUnregistered(serviceInterface, registration);
        }
    }

    @Override
    public <T> void addListener(Class<T> service, RegistrationListener<T> listener) {
        this.m_listenerMap.add(service, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addListener(Class<T> service, RegistrationListener<T> listener, boolean notifyForExistingProviders) {
        if (notifyForExistingProviders) {
            Set<ServiceRegistration> registrations = null;
            MultivaluedMap<Class<?>, ServiceRegistration> multivaluedMap = this.m_registrationMap;
            synchronized (multivaluedMap) {
                this.m_listenerMap.add(service, listener);
                registrations = this.getRegistrations(service);
            }
            for (ServiceRegistration registration : registrations) {
                listener.providerRegistered(registration, registration.getProvider(service));
            }
        } else {
            this.m_listenerMap.add(service, listener);
        }
    }

    @Override
    public <T> void removeListener(Class<T> service, RegistrationListener<T> listener) {
        this.m_listenerMap.remove(service, listener);
    }

    private <T> void fireProviderRegistered(Class<T> serviceInterface, Registration registration) {
        Set<RegistrationListener<T>> listeners = this.getListeners(serviceInterface);
        for (RegistrationListener<T> listener : listeners) {
            listener.providerRegistered(registration, registration.getProvider(serviceInterface));
        }
    }

    private <T> void fireProviderUnregistered(Class<T> serviceInterface, Registration registration) {
        Set<RegistrationListener<T>> listeners = this.getListeners(serviceInterface);
        for (RegistrationListener<T> listener : listeners) {
            listener.providerUnregistered(registration, registration.getProvider(serviceInterface));
        }
    }

    private <T> Set<RegistrationListener<T>> getListeners(Class<T> serviceInterface) {
        Set<RegistrationListener<?>> listeners = this.m_listenerMap.getCopy(serviceInterface);
        return listeners == null ? Collections.emptySet() : listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegistrationHook(RegistrationHook hook, boolean notifyForExistingProviders) {
        if (notifyForExistingProviders) {
            Set<ServiceRegistration> registrations = null;
            MultivaluedMap<Class<?>, ServiceRegistration> multivaluedMap = this.m_registrationMap;
            synchronized (multivaluedMap) {
                this.m_hooks.add(hook);
                registrations = this.getAllRegistrations();
            }
            for (ServiceRegistration registration : registrations) {
                hook.registrationAdded(registration);
            }
        } else {
            this.m_hooks.add(hook);
        }
    }

    @Override
    public void removeRegistrationHook(RegistrationHook hook) {
        this.m_hooks.remove(hook);
    }

    @Override
    public void unregisterAll(Class<?> clazz) {
        for (ServiceRegistration registration : this.getRegistrations(clazz)) {
            this.unregister(registration);
        }
    }

    private Set<ServiceRegistration> getAllRegistrations() {
        LinkedHashSet<ServiceRegistration> registrations = new LinkedHashSet<ServiceRegistration>();
        for (Set registrationSet : this.m_registrationMap.values()) {
            registrations.addAll(registrationSet);
        }
        return registrations;
    }

    public static class AnyFilter
    implements Filter {
        @Override
        public boolean match(Map<String, String> properties) {
            return true;
        }
    }

    private class ServiceRegistration
    implements Registration {
        private boolean m_unregistered = false;
        private Object m_provider;
        private Map<String, String> m_properties;
        private Class<?>[] m_serviceInterfaces;

        public ServiceRegistration(Object provider, Map<String, String> properties, Class<?>[] serviceInterfaces) {
            this.m_provider = provider;
            this.m_properties = properties;
            this.m_serviceInterfaces = Arrays.copyOf(serviceInterfaces, serviceInterfaces.length);
        }

        @Override
        public Map<String, String> getProperties() {
            return this.m_properties == null ? null : Collections.unmodifiableMap(this.m_properties);
        }

        @Override
        public Class<?>[] getProvidedInterfaces() {
            return this.m_serviceInterfaces;
        }

        @Override
        public <T> T getProvider(Class<T> serviceInterface) {
            if (serviceInterface == null) {
                throw new NullPointerException("serviceInterface may not be null");
            }
            for (Class<?> cl : this.m_serviceInterfaces) {
                if (!serviceInterface.equals(cl)) continue;
                return serviceInterface.cast(this.m_provider);
            }
            throw new IllegalArgumentException("Provider not registered with interface " + String.valueOf(serviceInterface));
        }

        @Override
        public Object getProvider() {
            return this.m_provider;
        }

        @Override
        public ServiceRegistry getRegistry() {
            return DefaultServiceRegistry.this;
        }

        @Override
        public boolean isUnregistered() {
            return this.m_unregistered;
        }

        @Override
        public void unregister() {
            this.m_unregistered = true;
            DefaultServiceRegistry.this.unregister(this);
            this.m_provider = null;
        }
    }
}

