/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.soa.filter;

import org.opennms.core.soa.filter.AttributeComparisonFilter;

public class GreaterThanFilter
extends AttributeComparisonFilter {
    private String m_value;

    public GreaterThanFilter(String attribute, String value) {
        super(attribute);
        this.m_value = value;
    }

    @Override
    protected boolean valueMatches(String value) {
        try {
            return Double.parseDouble(value) >= Double.parseDouble(this.m_value);
        }
        catch (NumberFormatException e) {
            return value.compareToIgnoreCase(this.m_value) >= 0;
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(").append(this.getAttribute()).append(">=").append(this.m_value).append(")");
        return buf.toString();
    }
}

