/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.reporting.rest.internal;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import org.opennms.api.reporting.ReportFormat;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.features.reporting.rest.internal.ReportDetails;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.reporting.core.DeliveryOptions;

public class ReportDetailsBuilder {
    private final ReportDetails reportDetails = new ReportDetails();

    public ReportDetailsBuilder withFormats(List<ReportFormat> formats) {
        this.reportDetails.setFormats(formats);
        return this;
    }

    public ReportDetailsBuilder withReportId(String reportId) {
        this.reportDetails.setReportId(reportId);
        return this;
    }

    public ReportDetailsBuilder withParameters(ReportParameters reportParameters) {
        this.reportDetails.setParameters(reportParameters);
        return this;
    }

    public ReportDetailsBuilder withCategories(Collection<Category> categories) {
        this.reportDetails.setCategories(Lists.newArrayList(categories));
        return this;
    }

    public ReportDetailsBuilder withSurveillanceCategories(List<OnmsCategory> surveillanceCategories) {
        this.reportDetails.setSurveillanceCategories(surveillanceCategories);
        return this;
    }

    public ReportDetailsBuilder withDeliveryOptions(DeliveryOptions deliveryOptions) {
        this.reportDetails.setDeliveryOptions(deliveryOptions);
        return this;
    }

    public ReportDetailsBuilder withCronExpression(String cronExpression) {
        this.reportDetails.setCronExpression(cronExpression);
        return this;
    }

    public ReportDetailsBuilder withTimezones(List<String> timezones) {
        this.reportDetails.setTimezones(timezones);
        return this;
    }

    public ReportDetailsBuilder withDefaultTimezones() {
        ArrayList allAvailableIds = Lists.newArrayList((Object[])TimeZone.getAvailableIDs());
        allAvailableIds.removeAll(ZoneId.SHORT_IDS.keySet());
        return this.withTimezones(allAvailableIds);
    }

    public ReportDetails build() {
        if (Strings.isNullOrEmpty((String)this.reportDetails.getReportId())) {
            throw new IllegalStateException("ReportDetails must have a report Id");
        }
        return this.reportDetails;
    }
}

