/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.kvstore.blob.shell;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.distributed.kvstore.api.BlobStore;

@Command(scope="opennms", name="kv-benchmark-blob", description="Benchmark the blob store's throughput")
@Service
public class BlobStoreBenchmark
implements Action {
    @Reference
    private BlobStore blobStore;
    @Argument(index=0, description="The payload size in bytes", required=true)
    private int payloadSize;
    @Argument(index=1, description="The number of records", required=true)
    private int numberOfRecords;
    @Option(name="-t", aliases={"--just-timestamp"}, description="Whether or not to read just the timestamp")
    private boolean readJustTimestamp = false;
    @Option(name="-a", aliases={"--async"}, description="Whether or not to use async")
    private boolean async = false;
    private static final String CONTEXT = "benchmark";
    private static final String KEY = "test";
    private final MetricRegistry metrics = new MetricRegistry();
    private byte[] writePayload;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final Retry asyncRetry = Retry.of((String)"blobStoreBenchmark", (RetryConfig)RetryConfig.custom().maxAttempts(Integer.MAX_VALUE).waitDuration(Duration.ofMillis(10L)).build());

    public Object execute() throws InterruptedException {
        System.out.println(String.format("BlobStore implementation in use: %s", this.blobStore.getName()));
        this.writePayload = new byte[this.payloadSize];
        StringBuilder throughputResultsBuilder = new StringBuilder();
        throughputResultsBuilder.append(this.benchmark("write", this::writeAsync, this::write));
        String readThroughput = this.benchmark("read", this::readAsync, this::read);
        if (!this.readJustTimestamp) {
            throughputResultsBuilder.append('\n').append(readThroughput);
        }
        ConsoleReporter reporter = ConsoleReporter.forRegistry((MetricRegistry)this.metrics).build();
        reporter.report();
        reporter.close();
        System.out.println(throughputResultsBuilder.toString());
        return null;
    }

    private CompletableFuture<?> timeAsyncOperation(Histogram results, Supplier<CompletableFuture<?>> futureSupplier) {
        long start = System.currentTimeMillis();
        return ((CompletionStage)Retry.decorateCompletionStage((Retry)this.asyncRetry, (ScheduledExecutorService)this.executorService, () -> ((CompletableFuture)futureSupplier.get()).thenAccept(v -> results.update(System.currentTimeMillis() - start))).get()).toCompletableFuture();
    }

    private CompletableFuture<?> writeAsync(String key, Histogram results) {
        return this.timeAsyncOperation(results, () -> this.blobStore.putAsync(key, (Object)this.writePayload, CONTEXT, Integer.valueOf((int)TimeUnit.SECONDS.convert(1L, TimeUnit.HOURS))));
    }

    private CompletableFuture<?> readAsync(String key, Histogram results) {
        return this.timeAsyncOperation(results, () -> this.readJustTimestamp ? this.blobStore.getLastUpdatedAsync(key, CONTEXT) : this.blobStore.getAsync(key, CONTEXT));
    }

    private void timeOperation(Histogram results, Runnable operation) {
        long start = System.currentTimeMillis();
        operation.run();
        long elapsed = System.currentTimeMillis() - start;
        results.update(elapsed);
    }

    private void write(String key, Histogram results) {
        this.timeOperation(results, () -> this.blobStore.put(key, (Object)this.writePayload, CONTEXT, Integer.valueOf((int)TimeUnit.SECONDS.convert(1L, TimeUnit.HOURS))));
    }

    private void read(String key, Histogram results) {
        this.timeOperation(results, this.readJustTimestamp ? () -> this.blobStore.getLastUpdated(key, CONTEXT) : () -> this.blobStore.get(key, CONTEXT));
    }

    private String benchmark(String methodType, BiFunction<String, Histogram, CompletableFuture<?>> asyncFunction, BiConsumer<String, Histogram> syncFunction) throws InterruptedException {
        System.out.print(String.format("Benchmarking %s performance...", methodType));
        Histogram results = this.metrics.histogram(String.format("%s times", methodType));
        AtomicLong totalTime = new AtomicLong(0L);
        CompletableFuture<Boolean> benchmarkFuture = CompletableFuture.supplyAsync(() -> {
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            long start = System.currentTimeMillis();
            for (int i = 0; i < this.numberOfRecords; ++i) {
                String key = String.format("%s-%d", KEY, i);
                if (this.async) {
                    futures.add((CompletableFuture)asyncFunction.apply(key, results));
                    continue;
                }
                syncFunction.accept(key, results);
            }
            if (this.async) {
                try {
                    CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            totalTime.set(System.currentTimeMillis() - start);
            return true;
        });
        while (!benchmarkFuture.getNow(false).booleanValue()) {
            System.out.print('.');
            Thread.sleep(1000L);
        }
        System.out.println("done");
        double throughPut = (double)(this.payloadSize * this.numberOfRecords) / 1024.0 / ((double)totalTime.get() / 1000.0);
        return String.format("%s throughput: %.2f KB/s", methodType, throughPut);
    }
}

