/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.timeseries.immutables;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import org.opennms.integration.api.v1.timeseries.Tag;

public class ImmutableTag
implements Tag,
Serializable {
    private final String key;
    private final String value;

    public ImmutableTag(String key, String value) {
        this.key = key;
        this.value = Objects.requireNonNull(value, key);
    }

    public ImmutableTag(String value) {
        this(null, value);
    }

    public String toString() {
        return this.key + "=" + this.value;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)o;
        return Objects.equals(this.key, tag.getKey()) && Objects.equals(this.value, tag.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public int compareTo(Tag other) {
        if (other == null) {
            return 1;
        }
        return Comparator.comparing(Tag::getKey, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Tag::getValue).compare(this, other);
    }
}

