/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opennms.core.tasks.AbstractTask;
import org.opennms.core.tasks.NeedsContainer;
import org.opennms.core.tasks.RunInBatch;
import org.opennms.core.tasks.SyncTask;
import org.opennms.core.tasks.Task;
import org.opennms.core.tasks.TaskBuilder;
import org.opennms.core.tasks.TaskCoordinator;

public abstract class ContainerTask<T extends ContainerTask<?>>
extends AbstractTask {
    protected final AbstractTask m_triggerTask;
    private final List<Task> m_children = Collections.synchronizedList(new ArrayList());
    private final TaskBuilder<T> m_builder = this.createBuilder();

    public ContainerTask(TaskCoordinator coordinator, ContainerTask<?> parent) {
        super(coordinator, parent);
        this.m_triggerTask = new TriggerTask(coordinator, this);
    }

    private final TaskBuilder<T> createBuilder() {
        return new TaskBuilder<ContainerTask>(this);
    }

    public final TaskBuilder<T> getBuilder() {
        return this.m_builder;
    }

    @Override
    public void addPrerequisite(AbstractTask task) {
        super.addPrerequisite(task);
        this.m_triggerTask.addPrerequisite(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preSchedule() {
        ArrayList<Task> children;
        this.m_triggerTask.schedule();
        List<Task> list = this.m_children;
        synchronized (list) {
            children = new ArrayList<Task>(this.m_children);
            this.m_children.clear();
        }
        for (Task task : children) {
            task.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AbstractTask task) {
        boolean scheduleChild;
        super.addPrerequisite(task);
        this.addChildDependencies(task);
        List<Task> list = this.m_children;
        synchronized (list) {
            scheduleChild = this.isScheduled();
            if (!scheduleChild) {
                this.m_children.add(task);
            }
        }
        if (scheduleChild) {
            task.schedule();
        }
    }

    public void add(RunInBatch runInBatch) {
        this.getBuilder().add(runInBatch);
    }

    public void add(NeedsContainer needsContainer) {
        this.getBuilder().add(needsContainer);
    }

    protected AbstractTask getTriggerTask() {
        return this.m_triggerTask;
    }

    @Override
    protected void completeSubmit() {
        this.getCoordinator().markTaskAsCompleted(this);
    }

    public SyncTask add(Runnable runnable) {
        SyncTask task = this.createTask(runnable);
        this.add(task);
        return task;
    }

    public SyncTask add(Runnable runnable, String schedulingHint) {
        SyncTask task = this.createTask(runnable, schedulingHint);
        this.add(task);
        return task;
    }

    private SyncTask createTask(Runnable runnable) {
        return this.getCoordinator().createTask(this, runnable);
    }

    private SyncTask createTask(Runnable runnable, String schedulingHint) {
        return this.getCoordinator().createTask(this, runnable, schedulingHint);
    }

    protected void addChildDependencies(AbstractTask child) {
        child.addPrerequisite(this.m_triggerTask);
    }

    private static final class TriggerTask
    extends AbstractTask {
        private final ContainerTask<?> m_parent;

        public TriggerTask(TaskCoordinator coordinator, ContainerTask<?> parent) {
            super(coordinator, parent);
            this.m_parent = parent;
        }

        @Override
        protected void completeSubmit() {
            this.getCoordinator().markTaskAsCompleted(this);
        }

        @Override
        public String toString() {
            return "Trigger For " + this.m_parent.toString();
        }
    }
}

