/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import org.opennms.netmgt.model.AttributeVisitor;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.ResourceVisitor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class AttributeMatchingResourceVisitor
implements ResourceVisitor,
InitializingBean {
    private AttributeVisitor m_attributeVisitor;
    private String m_attributeMatch;

    public void visit(OnmsResource resource) {
        for (OnmsAttribute attribute : resource.getAttributes()) {
            if (!this.m_attributeMatch.equals(attribute.getName())) continue;
            this.m_attributeVisitor.visit(attribute);
        }
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_attributeVisitor != null ? 1 : 0) != 0, (String)"property attributeVisitor must be set to a non-null value");
        Assert.state((this.m_attributeMatch != null ? 1 : 0) != 0, (String)"property attributeMatch must be set to a non-null value");
    }

    public String getAttributeMatch() {
        return this.m_attributeMatch;
    }

    public void setAttributeMatch(String attributeMatch) {
        this.m_attributeMatch = attributeMatch;
    }

    public AttributeVisitor getAttributeVisitor() {
        return this.m_attributeVisitor;
    }

    public void setAttributeVisitor(AttributeVisitor attributeVisitor) {
        this.m_attributeVisitor = attributeVisitor;
    }
}

