/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.opennms.features.config.service.api.ConfigUpdateInfo;
import org.opennms.features.config.service.impl.AbstractCmJaxbConfigDao;
import org.opennms.netmgt.config.provisiond.ProvisiondConfiguration;
import org.opennms.netmgt.config.provisiond.RequisitionDef;
import org.opennms.netmgt.dao.api.ProvisiondConfigurationDao;
import org.opennms.netmgt.dao.jaxb.callback.ConfigurationReloadEventCallback;
import org.opennms.netmgt.dao.jaxb.callback.ProvisiondConfigurationValidationCallback;
import org.opennms.netmgt.events.api.EventForwarder;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultProvisiondConfigurationDao
extends AbstractCmJaxbConfigDao<ProvisiondConfiguration>
implements ProvisiondConfigurationDao {
    public static final String CONFIG_NAME = "provisiond";
    @Autowired
    private EventForwarder eventForwarder;

    public DefaultProvisiondConfigurationDao() {
        super(ProvisiondConfiguration.class, "Provisiond Configuration");
    }

    public ProvisiondConfiguration getConfig() throws IOException {
        return (ProvisiondConfiguration)this.getConfig(this.getDefaultConfigId());
    }

    public void reloadConfiguration() throws IOException {
        this.loadConfig(this.getDefaultConfigId());
    }

    public RequisitionDef getDef(String defName) throws IOException {
        List<RequisitionDef> defs = this.getDefs();
        if (defs != null) {
            for (RequisitionDef def : defs) {
                if (!defName.equals(def.getImportName().orElse(null))) continue;
                return def;
            }
        }
        return null;
    }

    public List<RequisitionDef> getDefs() throws IOException {
        return this.getConfig().getRequisitionDefs();
    }

    public String getForeignSourceDir() throws IOException {
        return this.getConfig().getForeignSourceDir();
    }

    public String getRequisitionDir() throws IOException {
        return this.getConfig().getRequistionDir();
    }

    public Integer getImportThreads() throws IOException {
        return this.getConfig().getImportThreads().intValue();
    }

    public Integer getScanThreads() throws IOException {
        return this.getConfig().getScanThreads().intValue();
    }

    public Integer getRescanThreads() throws IOException {
        return this.getConfig().getRescanThreads().intValue();
    }

    public Integer getWriteThreads() throws IOException {
        return this.getConfig().getWriteThreads().intValue();
    }

    public Consumer<ConfigUpdateInfo> getUpdateCallback() {
        return new ConfigurationReloadEventCallback(this.eventForwarder);
    }

    public Consumer<ConfigUpdateInfo> getValidationCallback() {
        return new ProvisiondConfigurationValidationCallback();
    }

    public String getConfigName() {
        return CONFIG_NAME;
    }

    public Map<String, Long> getRequisitionSchemeCount() throws IOException {
        return this.getDefs().stream().filter(r -> r.getImportUrlResource().isPresent()).map(r -> {
            try {
                return new URL((String)r.getImportUrlResource().get());
            }
            catch (MalformedURLException e) {
                return null;
            }
        }).filter(r -> r != null).collect(Collectors.groupingBy(r -> r.getProtocol(), Collectors.counting()));
    }
}

